(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    126026,       2916]*)
(*NotebookOutlinePosition[    126928,       2946]*)
(*  CellTagsIndexPosition[    126884,       2942]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Clairaut Equations"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The ordinary Clairaut differential equation has the form ",
  StyleBox["y == x y' + f[y']", "Input"],
  ". \n\nOne can",
  StyleBox[" solve this equation by differentiating",
    FontVariations->{"Underline"->True}],
  StyleBox[" to get",
    FontVariations->{"CompatibilityType"->0}],
  " ",
  StyleBox["y' == y' + xy'' + f'[y']y''", "Input"],
  ". From this we obtain  ",
  StyleBox["y''(x + f'[y'])==0", "Input"],
  ". \nThe solutions of this are those functions which make either factor 0. \
\n\nWe have the solutions where ",
  StyleBox["y'' == 0", "Input"],
  ". These have ",
  StyleBox["y' == c", "Input"],
  ", a constant, which gives the one-parameter family of solutions ",
  StyleBox["y = x*c + f[c]", "Input"],
  ".\n\nWe have the solutions where ",
  StyleBox["x + f'[y'] == 0", "Input"],
  ". Taken together with the original differential equation these give the \
parametric representation (t = y')\n\t\t\t",
  StyleBox["x = -f'[y'] = f'[t]", "Input"],
  "\n\t\t\t",
  StyleBox["y = x*y' + f[y'] = f[t] + t*f'[t]", "Input"],
  "\nfor a solution which is not of the form  ",
  StyleBox["y = x*c + f[c]", "Input"],
  ". This is a ",
  StyleBox["singular solution",
    FontVariations->{"Underline"->True}],
  ". Often it is instructive to eliminate the parameter t from this pair of \
equations."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve the Clairaut differential equation ",
  StyleBox["y == x y' +1/2(y')^2", "Input"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The one-parameter family"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = x\ c + c\^2\/2\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c\^2\/2 + c\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(samples = Table[y[x] /. c \[Rule] k, {k, \(-3\), 3, 1\/2}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({9\/2 - 3\ x, 25\/8 - \(5\ x\)\/2, 2 - 2\ x, 9\/8 - \(3\ x\)\/2, 
      1\/2 - x, 1\/8 - x\/2, 0, 1\/8 + x\/2, 1\/2 + x, 9\/8 + \(3\ x\)\/2, 
      2 + 2\ x, 25\/8 + \(5\ x\)\/2, 9\/2 + 3\ x}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lines = 
      Plot[Evaluate[samples], {x, \(-3\), 3}, 
        PlotRange \[Rule] {\(-5\), 5}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.0618034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .0618 -12 -4.5 ]
[.4875 .0618 0 4.5 ]
[.4875 .18541 -12 -4.5 ]
[.4875 .18541 0 4.5 ]
[.4875 .43262 -6 -4.5 ]
[.4875 .43262 0 4.5 ]
[.4875 .55623 -6 -4.5 ]
[.4875 .55623 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .0618 m
.50625 .0618 L
s
[(-4)] .4875 .0618 1 0 Mshowa
.5 .18541 m
.50625 .18541 L
s
[(-2)] .4875 .18541 1 0 Mshowa
.5 .43262 m
.50625 .43262 L
s
[(2)] .4875 .43262 1 0 Mshowa
.5 .55623 m
.50625 .55623 L
s
[(4)] .4875 .55623 1 0 Mshowa
.125 Mabswid
.5 .09271 m
.50375 .09271 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.47354 .61803 m
.49955 .58766 L
.53984 .5406 L
.57861 .49531 L
.61984 .44715 L
.65954 .40077 L
.69774 .35616 L
.73838 .30868 L
.77751 .26297 L
.81909 .2144 L
.85916 .1676 L
.89771 .12257 L
.93871 .07468 L
.97619 .0309 L
s
.38095 .61803 m
.3815 .6175 L
.42237 .57772 L
.46172 .53942 L
.49955 .50259 L
.53984 .46337 L
.57861 .42563 L
.61984 .3855 L
.65954 .34685 L
.69774 .30967 L
.73838 .27011 L
.77751 .23202 L
.81909 .19155 L
.85916 .15254 L
.89771 .11502 L
.93871 .07511 L
.97619 .03863 L
s
.2619 .61803 m
.30316 .58591 L
.34309 .55482 L
.3815 .5249 L
.42237 .49308 L
.46172 .46244 L
.49955 .43297 L
.53984 .4016 L
.57861 .37141 L
.61984 .33931 L
.65954 .30838 L
.69774 .27864 L
.73838 .24699 L
.77751 .21652 L
.81909 .18414 L
.85916 .15294 L
.89771 .12292 L
.93871 .09099 L
.97619 .0618 L
s
.08995 .61803 m
.10458 .60949 L
.14415 .58638 L
.18221 .56415 L
.22272 .54049 L
.26171 .51772 L
.30316 .49351 L
.34309 .47019 L
.3815 .44776 L
.42237 .42389 L
.46172 .4009 L
.49955 .37881 L
.53984 .35528 L
.57861 .33263 L
.61984 .30856 L
.65954 .28537 L
.69774 .26306 L
.73838 .23932 L
.77751 .21647 L
.81909 .19218 L
.85916 .16878 L
.89771 .14627 L
.93871 .12232 L
.97619 .10043 L
s
.02381 .52533 m
.06244 .51029 L
.10458 .49388 L
.14415 .47847 L
.18221 .46365 L
.22272 .44788 L
.26171 .4327 L
.30316 .41656 L
.34309 .40102 L
.3815 .38606 L
.42237 .37015 L
.46172 .35482 L
.49955 .34009 L
.53984 .32441 L
.57861 .30931 L
.61984 .29326 L
.65954 .2778 L
.69774 .26293 L
.73838 .2471 L
.77751 .23187 L
.81909 .21568 L
.85916 .20008 L
.89771 .18507 L
.93871 .1691 L
.97619 .15451 L
s
.02381 .40945 m
.06244 .40193 L
.10458 .39372 L
.14415 .38602 L
.18221 .37861 L
.22272 .37072 L
.26171 .36313 L
.30316 .35506 L
.34309 .34729 L
.3815 .33981 L
.42237 .33186 L
.46172 .3242 L
.49955 .31683 L
.53984 .30899 L
.57861 .30144 L
.61984 .29341 L
.65954 .28568 L
.69774 .27825 L
.73838 .27033 L
.77751 .26272 L
.81909 .25462 L
.85916 .24682 L
.89771 .23932 L
.93871 .23133 L
.97619 .22404 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .22404 m
.06244 .23156 L
.10458 .23976 L
.14415 .24747 L
.18221 .25487 L
.22272 .26276 L
.26171 .27035 L
.30316 .27842 L
.34309 .28619 L
.3815 .29367 L
.42237 .30163 L
.46172 .30929 L
.49955 .31666 L
.53984 .3245 L
.57861 .33205 L
.61984 .34007 L
.65954 .3478 L
.69774 .35524 L
.73838 .36315 L
.77751 .37077 L
.81909 .37886 L
.85916 .38666 L
.89771 .39417 L
.93871 .40215 L
.97619 .40945 L
s
.02381 .15451 m
.06244 .16955 L
.10458 .18596 L
.14415 .20137 L
.18221 .21618 L
.22272 .23196 L
.26171 .24714 L
.30316 .26327 L
.34309 .27882 L
.3815 .29378 L
.42237 .30969 L
.46172 .32501 L
.49955 .33974 L
.53984 .35543 L
.57861 .37053 L
.61984 .38658 L
.65954 .40204 L
.69774 .41691 L
.73838 .43274 L
.77751 .44797 L
.81909 .46416 L
.85916 .47976 L
.89771 .49477 L
.93871 .51074 L
.97619 .52533 L
s
.02381 .10043 m
.06244 .123 L
.10458 .1476 L
.14415 .17072 L
.18221 .19294 L
.22272 .2166 L
.26171 .23937 L
.30316 .26358 L
.34309 .2869 L
.3815 .30934 L
.42237 .3332 L
.46172 .35619 L
.49955 .37828 L
.53984 .40181 L
.57861 .42446 L
.61984 .44853 L
.65954 .47173 L
.69774 .49403 L
.73838 .51777 L
.77751 .54062 L
.81909 .56491 L
.85916 .58831 L
.89771 .61083 L
s
.89771 .61083 m
.91005 .61803 L
s
.02381 .0618 m
.06244 .09189 L
.10458 .1247 L
.14415 .15552 L
.18221 .18515 L
.22272 .2167 L
.26171 .24706 L
.30316 .27934 L
.34309 .31043 L
.3815 .34034 L
.42237 .37217 L
.46172 .40281 L
.49955 .43227 L
.53984 .46365 L
.57861 .49384 L
.61984 .52594 L
.65954 .55686 L
.69774 .58661 L
s
.69774 .58661 m
.7381 .61803 L
s
.02381 .03863 m
.06244 .07623 L
.10458 .11725 L
.14415 .15577 L
.18221 .19281 L
.22272 .23224 L
.26171 .2702 L
.30316 .31054 L
.34309 .34941 L
.3815 .3868 L
.42237 .42658 L
.46172 .46489 L
.49955 .50172 L
.53984 .54093 L
.57861 .57867 L
s
.57861 .57867 m
.61905 .61803 L
s
.02381 .0309 m
.06244 .07603 L
.10458 .12525 L
.14415 .17147 L
.18221 .21592 L
.22272 .26324 L
.26171 .30879 L
.30316 .3572 L
.34309 .40384 L
.3815 .44871 L
.42237 .49645 L
.46172 .54241 L
.49955 .58661 L
s
.49955 .58661 m
.52646 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{376.75, 232.875},
  ImageMargins->{{10, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005h0000j2000`400?l00000o`00003o^oooool0
0ol0003oooooooooo`2jooooo`00^oooool00ol0003oooooooooo`2jooooo`00^oooool00ol0003o
ooooooooo`2jooooo`00^oooool00ol0003oooooooooo`2jooooo`00^oooool00ol0003ooooooooo
o`2jooooo`00^oooool00ol0003oooooooooo`2jooooo`00^oooool00ol0003oooooooooo`2joooo
o`00^oooool00ol0003oooooooooo`2jooooo`00^oooool00ol0003oooooooooo`2jooooo`00^ooo
ool00ol0003oooooooooo`2jooooo`00^oooool00ol0003oooooooooo`2jooooo`002Oooool00ol0
003oooooooooo`2_ooooo`?o0000/?ooool00ol0003oooooooooo`07ooooo`002Oooool00ol0003o
ooooooooo`2_ooooo`03o`000?oooooooooo0;3ooooo00?o0000ooooooooool01oooool000[ooooo
00?o0000ooooooooool0[_ooool00ol0003oooooooooo`2_ooooo`03o`000?oooooooooo00Sooooo
0009ooooo`03o`000?oooooo00000:oooooo00?o0000ooooooooool0[_ooool00ol0003oooooo`00
0009ooooo`002_ooool00ol0003oooooo`00002^ooooo`03o`000?oooooooooo0:gooooo00?o0000
ooooool000002_ooool000_ooooo00?o0000ooooool00000[Oooool00ol0003oooooooooo`2/oooo
o`03o`000?oooooo000000_ooooo000<ooooo`03o`000?oooooo00000:cooooo00?o0000oooooooo
ool0Zoooool00ol0003oooooo`00000<ooooo`003Oooool2o`000:cooooo00?o0000ooooooooool0
Zoooool2o`0000gooooo000>ooooo`;o0000Zoooool00ol0003oooooooooo`2Zooooo`;o00003_oo
ool000oooooo0_l0002Rooooo`?o00001Oooool00ol0003oooooooooo`2Yooooo`;o00003oooool0
013ooooo0_l0002Rooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Z?ooool2o`00
013ooooo000Aooooo`;o0000V?ooool5o`000003ooooool0003o000000?o00001Oooool00ol0003o
ooooooooo`2Wooooo`;o00004Oooool000Wooooo0_l00007ooooo`03o`000?oooooooooo09cooooo
00Co0000oooooooooooo00001_ooool4o`000:Kooooo00?o0000ooooooooool01Oooool2o`0000Wo
oooo000;ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0W?ooool00ol0003ooooo
o`000006ooooo`03o`000?oooooooooo0:Kooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`09ooooo`003?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09cooooo0_l0
0006ooooo`03o`000?oooooooooo0:Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0:ooooo`003Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09cooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`2Tooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool02oooool000kooooo0_l00006ooooo`03o`000?oooooooooo0:;ooooo00?o0000oooo
ooooool0Xoooool00ol0003oooooooooo`04ooooo`;o00003_ooool0013ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`2Qooooo`03o`000?oooooooooo0:;ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0>ooooo`004Oooool00ol0003oooooooooo`03ooooo`;o0000
X_ooool00ol0003oooooooooo`2Qooooo`;o00001Oooool00ol0003oooooooooo`0?ooooo`004_oo
ool2o`0000Cooooo0_l0002Qooooo`03o`000?oooooooooo0:3ooooo0_l00004ooooo`;o00004_oo
ool001Cooooo00?o0000ooooooooool00_ooool2o`000:3ooooo00?o0000ooooooooool0Woooool2
o`0000Cooooo00?o0000ooooooooool04_ooool001Gooooo00?o0000ooooooooool00_ooool2o`00
09oooooo00?o0000ooooooooool0W_ooool2o`0000Cooooo00?o0000ooooooooool04oooool001Ko
oooo00?o0000ooooooooool00_ooool2o`0009kooooo00?o0000ooooooooool0WOooool2o`0000Co
oooo00?o0000ooooooooool05?ooool001Oooooo0_l00003ooooo`;o0000WOooool3o`0009cooooo
0_l00003ooooo`;o00005oooool001Wooooo00Ko0000oooooooooooo0000ooooool0002Looooo`03
o`000?oooooooooo09_ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`0Gooooo`00
6_ooool01_l0003oooooooooool0003oooooo`0009_ooooo00?o0000ooooooooool0V_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo01Sooooo0009ooooo`;o00004?ooool2o`000004
ooooool0003oooooo`0009[ooooo00?o0000ooooooooool0VOooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo00kooooo0_l00009ooooo`002oooool00ol0003oooooooooo`0?ooooo`05
o`000?oooooo0000ooooool00000VOooool00ol0003oooooooooo`2Hooooo`04o`000?oooooo0000
ooooo`;o00004?ooool00ol0003oooooooooo`09ooooo`003?ooool2o`00013ooooo00Go0000oooo
ool0003oooooo`00002Hooooo`03o`000?oooooooooo09Oooooo00Go0000ooooool0003oooooo`00
000@ooooo`;o00003?ooool000kooooo00?o0000ooooooooool03_ooool3o`000003ooooool0003o
oooo09Kooooo00?o0000ooooooooool0U_ooool01Ol0003oooooo`000?oooooo0000013ooooo00?o
0000ooooooooool03?ooool000oooooo0_l0000@ooooo`;o000000?oooooo`000?ooool0UOooool0
0ol0003oooooooooo`2Eooooo`03o`000?oooooooooo00;o00003oooool2o`0000oooooo000Aoooo
o`;o00003oooool01?l0003oooooooooool0002Eooooo`03o`000?oooooooooo09Cooooo00?o0000
ooooooooool00_l0000>ooooo`;o00004Oooool001?ooooo00?o0000ooooooooool03Oooool2o`00
0003ooooool0003ooooo09?ooooo00?o0000ooooooooool0T_ooool2o`0000;ooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0Aooooo`005?ooool2o`0000kooooo0_l000000ooooooo
0000o`00002Booooo`03o`000?oooooooooo097ooooo00Go0000ooooooooooooooooo`00000>oooo
o`;o00005?ooool001Kooooo00?o0000ooooooooool03?ooool2o`0000;ooooo00?o0000oooooooo
ool0Soooool00ol0003oooooooooo`2@ooooo`05o`000?ooooooooooooooool000003_ooool00ol0
003oooooooooo`0Dooooo`005oooool2o`0000gooooo0ol000000ooooooo0000ooooo`2?ooooo`?o
0000Soooool00ol0003oooooooooo`02o`0000gooooo0_l0000Gooooo`006Oooool2o`0000cooooo
00Go0000ooooool0003oooooo`00002?ooooo`03o`000?oooooooooo08kooooo00Ko0000oooooooo
oooo0000ooooool0000;ooooo`;o00006Oooool001_ooooo00?o0000ooooooooool02Oooool01_l0
003oooooooooool0003oooooo`0008kooooo00?o0000ooooooooool0SOooool01_l0003ooooooooo
ool0003oooooo`0000_ooooo00?o0000ooooooooool06Oooool001cooooo0_l0000:ooooo`06o`00
0?ooooooooooo`000?oooooo0000SOooool00ol0003oooooooooo`2<ooooo`06o`000?oooooo0000
o`000?oooooo00002_ooool2o`0001cooooo000Nooooo`;o00002Oooool00ol0003oooooooooo`03
o`0008cooooo00?o0000ooooooooool0Roooool00ol0003oooooo`000002ooooo`03o`000?oooooo
oooo00Oooooo0_l0000Nooooo`008?ooool2o`0000Sooooo00Co0000oooooooooooooooo0_l0002;
ooooo`03o`000?oooooooooo08[ooooo0ol00002ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool07_ooool002;ooooo0_l00007ooooo`04o`000?ooooooooooooooo`;o0000R_ooool0
0ol0003oooooooooo`29ooooo`;o00000oooool00ol0003oooooooooo`06ooooo`;o00008Oooool0
02Cooooo00?o0000ooooooooool01Oooool01?l0003oooooooooooooool2o`0008Wooooo00?o0000
ooooooooool0R?ooool2o`0000?ooooo00?o0000ooooooooool01Oooool2o`0002?ooooo000Uoooo
o`;o00001_ooool01?l0003oooooooooooooool2o`0008Sooooo00?o0000ooooooooool0Qoooool2
o`0000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Sooooo`009oooool2o`00
00Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo
08Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`;o00009_ooool002Wo
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Q?ooool00ol0003o
ooooooooo`25ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool2o`0002So
oooo000[ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`23ooooo`03
o`000?oooooooooo08?ooooo0_l00005ooooo`04o`000?ooooooooooooooo`;o0000:_ooool000Wo
oooo0_l0000Qooooo`;o00000_ooool00ol0003oooooooooo`03ooooo`;o0000Poooool3o`0008;o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02o`00027ooooo0_l00009ooooo`00
2oooool3o`00023ooooo0_l000000ooooooo0000ooooo`04ooooo`;o0000P_ooool00ol0003ooooo
ooooo`21ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00008?ooool3o`0000_o
oooo000>ooooo`?o00007oooool00ol0003oooooo`000005ooooo`;o0000POooool00ol0003ooooo
ooooo`20ooooo`03o`000?oooooooooo00Cooooo00Co0000ooooool0003o00007_ooool3o`0000ko
oooo000Aooooo`?o00007Oooool3o`0000Gooooo0_l00020ooooo`03o`000?oooooooooo07kooooo
0_l00006ooooo`?o00007Oooool3o`00017ooooo000Dooooo`?o00007?ooool2o`0000Gooooo0ol0
001nooooo`03o`000?oooooooooo07gooooo0_l00006ooooo`;o00007?ooool3o`0001Cooooo000G
ooooo`;o00007?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000007gooooo00?o0000
ooooooooool0O?ooool2o`0000Gooooo0_l0000Looooo`;o00005oooool001Wooooo0ol0000Joooo
o`;o00001?ooool00ol0003oooooo`00001looooo`03o`000?oooooooooo07_ooooo0_l00004oooo
o`;o000000?oooooo`000?ooool06?ooool3o`0001Wooooo000Looooo`?o00005oooool01?l0003o
ooooo`000?l00003ooooo`04o`000?oooooo0000o`0007[ooooo00?o0000ooooooooool0NOooool3
o`0000Cooooo00Co0000oooooooooooo00006?ooool2o`0001cooooo000Oooooo`;o00005_ooool0
1?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0007Wooooo00?o0000ooooooooool0
N?ooool00ol0003oooooo`000003ooooo`;o00000_ooool00ol0003oooooooooo`0Dooooo`?o0000
7_ooool0027ooooo0ol0000Dooooo`03o`000?oooooooooo00;o00000_ooool01?l0003ooooooooo
ool0001^ooooo`Go00001Oooool00ol0003oooooooooo`1gooooo`03o`000?oooooo000000;ooooo
0_l00003ooooo`03o`000?oooooooooo01?ooooo0_l0000Qooooo`009?ooool3o`0001;ooooo00Co
0000oooooooooooooooo0_l000001Ooooooo0000oooooooooooo000006kooooo00Co0000oooooooo
oooo00001Oooool00ol0003oooooooooo`1fooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Aooooo`?o00008oooool002Oooooo0_l0000Aooooo`03
o`000?oooooooooo00;ooooo0ol00002ooooo`;o0000IOooool5o`0000?ooooo00?o0000oooooooo
ool01Oooool4o`0007?ooooo0_l000000ooooooo0000ooooo`02o`0000Cooooo00?o0000oooooooo
ool04?ooool2o`0002Kooooo000Yooooo`?o00003oooool00ol0003oooooooooo`03ooooo`;o0000
0oooool00ol0003oooooooooo`1[ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
Loooool00ol0003oooooooooo`03o`0000Gooooo00?o0000ooooooooool03_ooool3o`0002Sooooo
000/ooooo`;o00003Oooool00ol0003oooooooooo`04ooooo`;o00000oooool00ol0003ooooooooo
o`1Wooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`1booooo`03o`00
0?oooooooooo00;o00001_ooool00ol0003oooooooooo`0=ooooo`;o0000:oooool002kooooo0ol0
000;ooooo`03o`000?oooooooooo00Gooooo0_l00002ooooo`03o`000?oooooooooo06Kooooo00Go
0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo073ooooo0_l00002ooooo`;o0000
1_ooool00ol0003oooooooooo`0;ooooo`?o0000;Oooool0037ooooo0_l0000:ooooo`03o`000?oo
oooooooo00Gooooo0ol000000ooooooo0000o`00001Wooooo`?o00001_ooool00ol0003ooooooooo
o`1_ooooo`03o`000?oooooooooo00;o00002?ooool00ol0003oooooooooo`09ooooo`;o0000<?oo
ool003?ooooo0ol00008ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`1]ooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool00_l00008
ooooo`03o`000?oooooooooo00Oooooo0ol0000booooo`00=_ooool2o`0000Oooooo00?o0000oooo
ooooool01Oooool01_l0003oooooo`000?l0003oooooo`0006kooooo00?o0000ooooooooool0K?oo
ool2o`000004ooooool0003o0000o`0000Sooooo00?o0000ooooooooool01_ooool2o`0003Gooooo
000hooooo`?o00001?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?o0000KOoo
ool00ol0003oooooooooo`1[ooooo`06o`000?oooooo0000o`000?oooooo00002?ooool00ol0003o
ooooooooo`04ooooo`?o0000=oooool003_ooooo0_l00003ooooo`03o`000?oooooooooo00Kooooo
00Co0000oooooooooooooooo0ol0001[ooooo`03o`000?oooooooooo06[ooooo0ol00002ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool2o`0003[ooooo000mooooo`;o0000
0_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`?o0000J_ooool00ol0003o
ooooooooo`1Xooooo`?o00000oooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooooooo
o`?o0000??ooool003oooooo1?l00008ooooo`03o`000?oooooooooo00;ooooo0_l0001Yooooo`03
o`000?oooooooooo06Oooooo0_l00004ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool00_l0000oooooo`00@_ooool2o`0000Sooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`1Vooooo`03o`000?oooooooooo06Kooooo0_l00004ooooo`03o`000?oooooooooo00Kooooo
1?l00011ooooo`00A?ooool2o`0000Oooooo00?o0000ooooooooool00oooool2o`0006Kooooo0ol0
001Tooooo`;o00001Oooool00ol0003oooooooooo`06ooooo`;o0000A?ooool004Cooooo00?o0000
ooooool000000_l00005ooooo`03o`000?oooooooooo00Cooooo0_l0001Tooooo`03o`000?oooooo
oooo06;ooooo0_l00006ooooo`03o`000?oooooooooo00Cooooo1?l00015ooooo`00AOooool01?l0
003oooooooooooooool2o`0000Cooooo00?o0000ooooooooool01?ooool3o`0006;ooooo00?o0000
ooooooooool0HOooool2o`0000Kooooo00?o0000ooooooooool00_ooool3o`0000;ooooo00?o0000
ooooooooool0A?ooool000Wooooo0ol0000jooooo`03o`000?oooooooooo00;ooooo0ol00002oooo
o`03o`000?oooooooooo00Cooooo1?l0001Pooooo`03o`000?oooooooooo05oooooo0ol00006oooo
o`04o`000?ooooooooooooooo`;o00001?ooool00ol0003oooooooooo`0hooooo`Co00002Oooool0
00cooooo1Ol0000fooooo`03o`000?oooooooooo00Cooooo0_l000000ooooooo0000ooooo`06oooo
o`03o`000?oooooo000005oooooo00?o0000ooooooooool0GOooool4o`0000Kooooo00?o0000oooo
ool000000_l00005ooooo`03o`000?oooooooooo03;ooooo1ol0000=ooooo`004Oooool5o`0003;o
oooo00?o0000ooooooooool01Oooool3o`0000Oooooo1?l0001Mooooo`03o`000?oooooooooo05_o
oooo0_l000000ooooooo0000ooooo`06ooooo`?o00001oooool00ol0003oooooooooo`0]ooooo`Ko
00005?ooool001Kooooo1Ol0000^ooooo`03o`000?oooooooooo00Oooooo0ol00006ooooo`04o`00
0?oooooo0000o`0005_ooooo00?o0000ooooooooool0F_ooool01?l0003oooooooooool00006oooo
o`;o00002Oooool00ol0003oooooooooo`0Yooooo`Go00006_ooool001_ooooo1Ol0000Zooooo`03
o`000?oooooooooo00Sooooo1?l00004ooooo`03o`000?oooooooooo00;o0000FOooool00ol0003o
ooooooooo`1Hooooo`;o000000?oooooo`000?l000001?ooool4o`0000Wooooo00?o0000oooooooo
ool09Oooool5o`0001oooooo000Pooooo`Go00009_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00?o00000_ooool2o`0000;ooooo0_l0001Gooooo`03o`000?oooooooooo05Kooooo
0_l00002ooooo`04o`000?ooooooooooooooo`?o00000_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo027ooooo1Ol0000Tooooo`009Oooool7o`00023ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`02ooooo`?o000000?oooooo`000?ooool00_ooool00ol0003ooooo
ooooo`1Dooooo`03o`000?oooooooooo05Cooooo0_l00003ooooo`03o`000?oooooo000000;o0000
1?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01cooooo1Ol0000Yooooo`00;?oo
ool7o`0001Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04ooooo`?o00000ooo
ool2o`0005Cooooo00?o0000ooooooooool0Doooool00ol0003oooooooooo`02ooooo`?o00001_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Sooooo1Ol0000^ooooo`00<oooool6
o`0001Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06ooooo`;o00000oooool2
o`0005;ooooo0ol0001Aooooo`;o00000oooool2o`0000Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Dooooo`Go0000<oooool003Wooooo1Ol0000@ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01oooool3o`0000;ooooo00?o0000ooooooooool0Coooool00ol0
003oooooooooo`1?ooooo`;o00000_ooool3o`0000Wooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0@ooooo`Go0000>?ooool003kooooo1Ol0000<ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool01oooool00ol0003oooooo`000004o`0004oooooo00?o0000oooooooo
ool0C_ooool00ol0003oooooooooo`02o`000003ooooool0003ooooo00Sooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0<ooooo`Go0000?Oooool004?ooooo1Ol00008ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool01oooool2o`0000;ooooo0ol0001>ooooo`03o`00
0?oooooooooo04cooooo1Ol00002ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`07ooooo`Ko0000@_ooool004Sooooo1Ol00004ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02?ooool01?l0003oooooooooooooool3o`0004cooooo
00?o0000ooooooooool0B_ooool4o`0000?ooooo0_l00009ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool00oooool5o`0004Sooooo001=ooooo`Ko00002oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00?ooooo0ol00019ooooo`03o`000?oooooooooo04Wooooo0ol0
0004ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00
0004o`0004gooooo001Booooo`Go00002?ooool00ol0003oooooooooo`08ooooo`;o00001Oooool3
o`0004Oooooo00?o0000ooooooooool0Aoooool2o`0000Kooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`06ooooo`Go0000D_ooool005?ooooo00Co0000oooooooooooooooo1Ol00004
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool5o`0004Cooooo00?o0000
ooooooooool0A?ooool3o`0000Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02
ooooo`Go00000_ooool00ol0003oooooooooo`1Booooo`00E?ooool00ol0003oooooooooo`05oooo
o`Ko00002oooool00ol0003oooooooooo`04ooooo`;o000000?oooooo`000?l00000@_ooool00ol0
003oooooooooo`12ooooo`?o00001oooool2o`0000[ooooo1_l00006ooooo`03o`000?oooooooooo
05?ooooo001Eooooo`03o`000?oooooooooo00Wooooo1Ol00008ooooo`;o00001_ooool2o`000004
ooooool0003o0000o`0003oooooo00?o0000ooooooooool0?oooool5o`0000Oooooo00?o0000oooo
ooooool01oooool4o`0000[ooooo00?o0000ooooooooool0E?ooool005Kooooo00?o0000oooooooo
ool02oooool00ol0003oooooo`000004o`0000Gooooo00?o0000ooooooooool01Oooool2o`0000;o
oooo0_l0000mooooo`03o`000?oooooooooo03gooooo0_l000000ooooooo0000o`000008ooooo`03
o`000?oooooooooo00?ooooo1Ol000000ooooooo0000ooooo`0:ooooo`03o`000?oooooooooo05Go
oooo000:ooooo`?o0000=oooool5o`0000kooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`03ooooo`Go000000?oooooo`000?ooool01oooool01?l0003oooooooooooooool6o`0003Oo
oooo00?o0000ooooooooool0=oooool6o`0000;ooooo00?o0000ooooooooool01oooool00ol0003o
ooooo`000004o`0000Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0=ooooo`Go
0000>?ooool3o`0000Wooooo0009ooooo`05o`000?ooooooooooooooool00000=oooool01?l0003o
ooooooooool0000?ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool6o`00
00Gooooo0_l00004ooooo`;o0000>?ooool3o`0003Sooooo0_l00003ooooo`;o00001oooool5o`00
00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0?ooooo`04o`000?oooooooooo
o`0003Oooooo00Go0000ooooooooooooooooo`000008ooooo`000oooool5o`0000Gooooo00?o0000
ooooooooool0;_ooool5o`0000?ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooool000002?l00003ooooo`Co0000=Oooool0
0ol0003oooooooooo`0eooooo`Co00000_ooool2o`0000Cooooo1_l0000<ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0kooooo`03o`000?oooooo
oooo00Kooooo000;ooooo`;o0000>_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`Ko000000?oooooo`00
0?ooool00_ooool2o`0003?ooooo00?o0000ooooooooool0<oooool2o`0000?ooooo00Co0000oooo
ool0003ooooo1Ol00004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo03Sooooo0_l00009ooooo`003Oooool00ol0
003oooooooooo`0dooooo`05o`000?ooooooooooooooool000004_ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01oooool4o`0000Cooooo0_l0000a
ooooo`03o`000?oooooooooo033ooooo0ol00004ooooo`Go00001oooool2o`0000cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`05o`000?ooooooooooooooool00000>ooo
ool00ol0003oooooooooo`06ooooo`002Oooool01Ol0003ooooooooooooooooo000003Kooooo00Go
0000ooooooooooooooooo`00000Booooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
2_ooool2o`0000Sooooo2?l000001?oooooo0000o`000?l0000^ooooo`03o`000?oooooooooo02ko
oooo0_l00002ooooo`Oo00002Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool04Oooool01Ol0003ooooooooooooooooo000003Oooooo00Go0000oooo
ooooooooooooo`000008ooooo`002_ooool3o`0003Sooooo0ol0000Dooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`06ooooo`04o`000?oooooo0000
o`0000?ooooo1_l0000/ooooo`03o`000?oooooooooo02_ooooo1ol00002ooooo`;o00000_ooool0
0ol0003oooooooooo`05ooooo`;o00003Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo01?ooooo0ol0000iooooo`?o00002Oooool005gooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool5o`00
02Sooooo00?o0000ooooooooool0:?ooool5o`0000Gooooo0_l0000;ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1Kooooo`00G_ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02Oooool2o`0000So
oooo1ol0000Sooooo`03o`000?oooooooooo02?ooooo1_l00008ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo05co
oooo001Oooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool2o`0000_ooooo
0_l00009ooooo`;o00000_ooool5o`0001kooooo00?o0000ooooooooool07_ooool5o`000003oooo
ool0003o000000Wooooo0_l0000;ooooo`;o00003_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo05gooooo001Pooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo0ol00004ooooo`Go00006Ooo
ool00ol0003oooooooooo`0Iooooo`Go00000oooool3o`0000Wooooo0_l0000<ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1Nooooo`00HOooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02_ooool2
o`0000_ooooo0_l00007ooooo`Go00005?ooool00ol0003oooooooooo`0Dooooo`Go00001_ooool2
o`0000[ooooo0_l0000=ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`1Oooooo`00H_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`?o00002Oooool5o`00
00oooooo00?o0000ooooooooool03oooool5o`0000Sooooo0ol0000:ooooo`;o00003Oooool2o`00
00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1Pooooo`00ool0001io`000000
2Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`08ooooo`;o00002oooool01?l0003oooooooooool00008ooooo`03
o`000?oooooooooo00;ooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo0ol000000ooooooo
0000ooooo`09ooooo`03o`000?oooooooooo00Oo00000_ooool01?l0003oooooooooooooool7o`00
0003ooooool0003ooooo00[ooooo00?o0000ooooool000000_l00007ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooo
o`0000_ooooo0_l0000:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo0009ooooo`03o`000?oooooooooo
03Sooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
00Wooooo00Go0000ooooooooooooooooo`00000>ooooo`03o`000?oooooooooo00gooooo0_l0000D
ooooo`Ko00004oooool3o`0000gooooo0_l0000?ooooo`05o`000?ooooooooooooooool000002ooo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0>Ooo
ool00ol0003oooooooooo`07ooooo`00IOooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool03?ooool2o`0000oooooo0ol0000<ooooo`Go00000_ooool0
1?l0003oooooooooooooool5o`0000_ooooo0ol0000>ooooo`;o00003oooool2o`0000oooooo00?o
0000ooooooooool03Oooool00ol0003oooooooooo`1Sooooo`00I_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00gooooo0_l0000>ooooo`;o00004?ooool2o`0000Gooooo1Ol00007
ooooo`03o`000?oooooooooo00Kooooo1Ol00003ooooo`?o00004?ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`1T
ooooo`00Ioooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0?ooooo`Go00003?ooool00ol0003oooooooooo`0;oooo
o`Go00003oooool2o`00013ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo06Gooooo001Wooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0=ooooo`;o00002oooool5o`0000;ooooo0_l0000<ooooo`03
o`000?oooooooooo00Sooooo0ol00005ooooo`Go00002?ooool2o`00017ooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo06Gooooo001Xooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool03_ooool2o`0000oooooo0_l00004ooooo`Go0000
2Oooool3o`0000Wooooo00?o0000ooooooooool01_ooool2o`0000gooooo1Ol00002ooooo`03o`00
0?oooooooooo00oooooo0_l0000@ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0
I_ooool006Wooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00gooooo1Ol0000Aooooo`?o00001_ooool00ol0003oooooooooo`03ooooo`?o00005?oo
ool5o`0000kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo06Oooooo001Zooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`07ooooo`Go00000_ooool2o`0001Gooooo0ol00003ooooo`04o`000?oooooo
ooooooooo`;o00005Oooool2o`0000Gooooo1Ol00008ooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`1Xooooo`00Joooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00oooooo00Co0000oooooooooooooooo1Ol00009ooooo`;o00005_oo
ool7o`0001Kooooo00?o0000ooooooooool02_ooool5o`0000;ooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo06Wooooo001/ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03Oooool5o`00013ooooo0_l0000Fooooo`Co00005Oooool2
o`0001;ooooo1Ol0000>ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0J_ooool0
06gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`07ooooo`Go00001?ooool00ol0
003oooooooooo`0@ooooo`;o00004Oooool3o`000003ooooool0003ooooo00?o00004Oooool2o`00
01?ooooo00?o0000ooooooooool00oooool5o`0000Sooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`1Zooooo`00KOooool00ol0003oooooooooo`0?ooooo`04o`000?oooooooooooooo
o`Go00002_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00cooooo0_l00004oooo
o`03o`000?oooooooooo00;ooooo0_l0000>ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool02Oooool5o`0000;ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`1[oooo
o`00K_ooool00ol0003oooooooooo`0>ooooo`Co00004?ooool00ol0003oooooooooo`0Aooooo`;o
00002_ooool2o`0000Kooooo00?o0000ooooooooool01?ooool3o`0000Wooooo0_l0000Dooooo`03
o`000?oooooooooo00oooooo1Ol0000>ooooo`03o`000?oooooooooo06cooooo001_ooooo`03o`00
0?oooooooooo00Sooooo1Ol00002ooooo`03o`000?oooooooooo013ooooo0_l0000Cooooo`;o0000
1Oooool3o`0000Sooooo00?o0000ooooooooool01oooool2o`0000Gooooo0_l0000Dooooo`;o0000
4Oooool00ol0003oooooooooo`03ooooo`Go00002?ooool00ol0003oooooooooo`1]ooooo`00L?oo
ool00ol0003oooooooooo`02ooooo`Go00002?ooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo01;ooooo0_l000000ooooooo0000o`00000;ooooo`03o`000?oooooooooo00Wooooo0ol0
00000ooooooo0000ooooo`0Dooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02Ooo
ool5o`0000;ooooo00?o0000ooooooooool0K_ooool006oooooo1_l0000>ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool04_ooool3o`0000cooooo00?o0000ooooooooool02oooool3
o`0001Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`Go0000K_ooool0
06[ooooo1Ol00003ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0>ooooo`?o00000oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Wooooo0_l00003ooooo`?o00004?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
017ooooo00Co0000oooooooooooooooo1Ol0001Yooooo`00IOooool5o`0000Sooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0Aooooo`;o00002oooool3o`0000Oooooo0_l00009oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool2o`0000cooooo0_l0000Boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool01oooool5o`0006Cooooo001Pooooo`Go
00003_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool01Oooool3o`0000cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`;o
00002oooool3o`0000Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo00gooooo1?l0001Pooooo`00Foooool5o`0001Cooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`0Booooo`04o`000?ooooooooooooooo`?o00004?ooool2o`0000Ko
oooo00?o0000ooooooooool01?ooool2o`00013ooooo0_l00005ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`Go0000Foooool005Kooooo
1Ol0000Jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool3o`0001Gooooo
0_l00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04_ooool3o`000003oooo
ool0003ooooo01;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Hooooo`Go0000
E_ooool0057ooooo1Ol0000Pooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03_oo
ool3o`000003ooooool0003o000001Oooooo00Co0000oooooooooooooooo0ol000000ooooooo0000
o`00000Gooooo`?o00004_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01kooooo
1Ol0001Aooooo`00C?ooool5o`0002Kooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0;ooooo`;o00001_ooool00ol0003oooooooooo`0Eooooo`;o000000?oooooo`000?ooool00_l0
000Hooooo`04o`000?ooooooooooooooo`?o00003_ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo02Cooooo1Ol0001<ooooo`00Aoooool5o`0002cooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`07ooooo`?o00002Oooool00ol0003oooooooooo`0Fooooo`?o00006Ooo
ool00ol0003oooooooooo`05ooooo`;o00002oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo02[ooooo1Ol00017ooooo`00@Oooool6o`0003;ooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`04ooooo`;o00003Oooool00ol0003oooooooooo`0Eooooo`?o00005oooool2
o`0000[ooooo0ol00007ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0<?ooool6
o`00047ooooo000jooooo`Oo0000>Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00?o00004?ooool2o`0001?ooooo0_l000000ooooooo0000ooooo`02o`0001Cooooo00?o0000oooo
ooooool03Oooool2o`0000Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0foooo
o`Go0000??ooool003Cooooo1_l00010ooooo`03o`000?oooooooooo017ooooo0_l0000Eooooo`03
o`000?oooooooooo00oooooo00Go0000ooooooooooooooooo`000003ooooo`;o00004?ooool2o`00
01;ooooo1?l0000Dooooo`03o`000?oooooooooo03cooooo1Ol0000gooooo`00;oooool5o`0004Oo
oooo00?o0000ooooooooool03Oooool3o`000003ooooool0003ooooo01Gooooo00?o0000oooooooo
ool03?ooool2o`0000Cooooo00?o0000ooooooooool00oooool2o`0000gooooo00?o0000oooooooo
ool05?ooool4o`00017ooooo00?o0000ooooooooool0@_ooool5o`0003;ooooo000Zooooo`Go0000
COooool00ol0003oooooooooo`0:ooooo`;o00001Oooool00ol0003oooooooooo`0Dooooo`03o`00
0?oooooooooo00Wooooo0_l00006ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00;ooooo0ol0000=ooooo`03o`00
0?oooooooooo04Sooooo1Ol0000]ooooo`009?ooool6o`0005?ooooo00?o0000ooooooooool01ooo
ool2o`0000Sooooo00?o0000ooooooooool05?ooool2o`0000Oooooo0_l00008ooooo`03o`000?oo
oooooooo00Kooooo0_l00007ooooo`;o00005_ooool00ol0003oooooooooo`06ooooo`?o00002Ooo
ool00ol0003oooooooooo`1>ooooo`Go0000:?ooool001oooooo1Ol0001Jooooo`03o`000?oooooo
oooo00?ooooo0ol0000;ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l00004ooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool02_ooool3o`0000Gooooo00?o0000ooooooooool0E?ooool5
o`0002?ooooo000Jooooo`Go0000H?ooool00ol0003oooooooooo`02o`0000oooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`02o`0000_ooooo00?o0000ooooooooool02_ooool2o`00
0003ooooool0003ooooo01Kooooo00?o0000ooooooooool03_ooool3o`000003ooooool0003ooooo
05_ooooo1Ol0000Nooooo`005Oooool5o`0006Kooooo0_l0000Booooo`03o`000?oooooooooo01Go
oooo0_l0000=ooooo`?o00002oooool3o`0001Kooooo00?o0000ooooooooool04_ooool2o`00067o
oooo1Ol0000Iooooo`004?ooool5o`0006Sooooo0ol000000ooooooo0000ooooo`0Booooo`03o`00
0?oooooooooo01;ooooo0_l000000ooooooo0000o`00000<ooooo`03o`000?oooooooooo00[ooooo
00Co0000oooooooooooooooo0_l0000Cooooo`03o`000?oooooooooo01?ooooo00?o0000ooooool0
00000_l0001Sooooo`Ko00004oooool000_ooooo1Ol0001[ooooo`;o00001?ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool2o`0006Oooooo
1ol0000<ooooo`002Oooool2o`0006gooooo0ol00007ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool03Oooool2o`0000Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Kooooo0_l0000>ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool01_ooool3o`0006_ooooo0ol00009ooooo`00M_ooool2o`0000_ooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0:ooooo`;o00002_ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Kooooo0_l0000;ooooo`;o00002oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00[ooooo0_l0001eooooo`00Loooool3o`0000kooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00_ooooo0_l00007oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool03Oooool3o`0007;ooooo001aooooo`;o
00004_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo0_l0000@ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`;o
00001_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo017ooooo0_l0001`ooooo`00
K_ooool3o`0001Gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`02ooooo`;o0000
4oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
4_ooool2o`0000?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Dooooo`?o0000
KOooool006_ooooo0ol0000Hooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo0000
5_ooool2o`0000?ooooo00Co0000oooooooooooooooo0_l0000Gooooo`03o`000?oooooo000001Go
oooo00?o0000ooooooooool06?ooool2o`0006_ooooo001Yooooo`;o00007?ooool00ol0003ooooo
ooooo`0Cooooo`;o00004_ooool5o`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`0Gooooo`?o00005?ooool00ol0003oooooooooo`0Kooooo`?o0000J?ooool006Kooooo
0ol0000Oooooo`03o`000?oooooooooo013ooooo0_l000000ooooooo0000o`00000Booooo`04o`00
0?ooooooooooo`0000?ooooo00Go0000ooooool0003oooooo`00000Iooooo`04o`000?oooooooooo
ooooo`;o00004_ooool00ol0003oooooooooo`0Nooooo`;o0000I_ooool006?ooooo0ol0000Soooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00Cooooo0ol0000Iooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0Qooooo`?o0000Hoooool0067ooooo0_l0000Wooooo`03
o`000?oooooooooo00_ooooo0_l00007ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool00oooool5o`0001Kooooo00?o0000ooooooooool01_ooool2o`0000gooooo00?o0000oooooooo
ool09Oooool2o`00067ooooo001Nooooo`?o0000:Oooool00ol0003oooooooooo`09ooooo`;o0000
2_ooool00ol0003oooooooooo`0<ooooo`05o`000?ooooooooooooooool000000oooool01Ol0003o
ooooo`000?oooooo000001Kooooo00?o0000ooooooooool02Oooool2o`0000[ooooo00?o0000oooo
ooooool0:?ooool3o`0005kooooo001Looooo`;o0000;Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0/ooooo`;o0000G?ooool0
05Wooooo0ol0000`ooooo`03o`000?oooooooooo00Cooooo0_l0000?ooooo`03o`000?oooooooooo
00_ooooo0ol00002ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00kooooo0_l00005ooooo`03o`000?oooooooooo02oooooo0_l0001J
ooooo`00Eoooool2o`0003Cooooo00Co0000oooooooooooooooo0_l0000Booooo`03o`000?oooooo
oooo00gooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0_l0000?ooooo`03o`000?oooooo
oooo017ooooo0_l00002ooooo`03o`000?oooooooooo03;ooooo0ol0001Gooooo`00E?ooool3o`00
03Oooooo00?o0000ooooool000005Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
01Cooooo0_l0000hooooo`;o0000EOooool005;ooooo0_l0000jooooo`;o00005oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo01Kooooo0_l0000iooooo`;o0000Doooool004oooooo
0ol0000jooooo`;o000000?oooooo`000?ooool05oooool00ol0003oooooooooo`06ooooo`;o0000
2?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`02o`0003Wooooo0ol0001@ooooo`00COooool2o`0003cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`;o00001_ooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>Oooool3o`0004gooooo001:
ooooo`?o0000??ooool2o`0000Kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01Oooool2o`0003cooooo0_l0001;
ooooo`00B?ooool2o`0003gooooo0_l00009ooooo`03o`000?oooooooooo01Kooooo00Co0000oooo
oooooooo00003?ooool00ol0003oooooooooo`0:ooooo`04o`000?ooooooooooo`0001Sooooo00?o
0000ooooooooool02?ooool2o`0003cooooo0ol00018ooooo`00AOooool3o`0003gooooo0_l0000<
ooooo`03o`000?oooooooooo01Kooooo0_l0000=ooooo`03o`000?oooooooooo00_ooooo0_l0000H
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0??ooool3o`0004Gooooo0013oooo
o`;o0000?oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Cooooo00?o0000oooo
ool000003Oooool3o`0000_ooooo0ol0000Gooooo`03o`000?oooooooooo00cooooo0_l0000ooooo
o`;o0000@oooool0043ooooo0ol0000oooooo`;o00004?ooool00ol0003oooooooooo`0Cooooo`05
o`000?ooooooooooooooool000003?ooool00ol0003oooooooooo`0:ooooo`05o`000?oooooooooo
ooooool000005Oooool00ol0003oooooooooo`0?ooooo`;o0000?oooool3o`00043ooooo000moooo
o`?o0000@?ooool2o`0001?ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0ooooo
o`;o0000?_ooool003[ooooo0ol00011ooooo`;o00005_ooool00ol0003oooooooooo`0>ooooo`;o
00001oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool01Oooool2o`00013ooooo00?o0000ooooooooool05?ooool2o`00047ooooo0ol0000kooooo`00
=oooool3o`0004?ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Gooooo`;o0000
@_ooool2o`0003Wooooo000eooooo`;o0000A?ooool2o`0001_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0:ooooo`;o00002oooool00ol0003oooooooooo`0Jooooo`;o0000@_oo
ool3o`0003Kooooo000booooo`?o0000A?ooool2o`0001kooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07?ooool2
o`0004?ooooo0ol0000cooooo`00<?ooool2o`0004Kooooo00?o0000ooooooooool07_ooool00ol0
003oooooooooo`06ooooo`;o00004?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
01oooooo00?o0000ooooooooool0@oooool3o`00033ooooo000]ooooo`?o0000A_ooool2o`0002;o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Aooooo`;o00001Oooool00ol0003o
ooooooooo`0Qooooo`;o0000A_ooool3o`0002gooooo000[ooooo`;o0000Aoooool2o`0002Gooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Dooooo`05o`000?ooooooooooooooool0
00009_ooool2o`0004Oooooo0ol0000Zooooo`00:?ooool3o`0004Sooooo00?o0000ooooooooool0
9_ooool01?l0003oooooooooool0000Gooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooo000002Wooooo0_l00018ooooo`?o00009oooool002Ko
oooo0_l00019ooooo`;o0000:_ooool2o`0001Wooooo00?o0000ooooooooool01?l0000Jooooo`;o
0000:oooool2o`0004Wooooo0_l0000Uooooo`008oooool3o`0004Wooooo0_l0000[ooooo`03o`00
0?oooooo000001[ooooo00Go0000ooooool0003oooooo`00000Kooooo`03o`000?oooooo000002co
oooo0_l00019ooooo`?o00008_ooool0023ooooo0ol0001;ooooo`03o`000?oooooooooo02[ooooo
00Co0000oooooooooooo00006oooool3o`0001_ooooo00Go0000ooooooooooooooooo`00000]oooo
o`03o`000?oooooooooo04Wooooo0_l0000Pooooo`007_ooool2o`0004cooooo0_l0000/ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0:oooool2o`0004_ooooo0ol0000Mooooo`00
6oooool3o`0004cooooo0_l0000/ooooo`;o00001_ooool00ol0003oooooooooo`0Gooooo`?o0000
6Oooool00ol0003oooooooooo`05ooooo`;o0000;Oooool2o`0004cooooo0_l0000Kooooo`006?oo
ool3o`0004gooooo0_l0000]ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool05Ooo
ool01Ol0003oooooo`000?oooooo000001Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0/ooooo`03o`000?oooooooooo04_ooooo0ol0000Hooooo`005_ooool2o`0004kooooo0_l0
000^ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04oooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0/ooooo`;o0000C_ooool2o`0001Kooooo000Cooooo`?o0000Coooool00ol0003ooooooooo
o`0]ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04Oooool01Ol0003ooooooooo
oooooooo000000?ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo02gooooo0_l0001>ooooo`?o00004oooool0017ooooo0_l0001@ooooo`;o0000;_oo
ool2o`0000oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`;o0000;ooo
ool00ol0003oooooooooo`1>ooooo`;o00004Oooool000oooooo0_l0001@ooooo`;o0000;oooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0]ooooo`;o0000D?ooool2o`0000oooooo000<ooooo`?o0000D?ooool2o`00
033ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool0;_ooool2o`00053ooooo0ol0000<ooooo`002_ooool2o`00057o
oooo0_l0000aooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0D?ooool2o`0000[o
oooo0009ooooo`03o`000?oooooooooo04oooooo0_l0000aooooo`;o00005oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Kooooo0ol00006ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool05_ooool2o`00033ooooo0_l0001Booooo`03o`000?oooooooooo00Oooooo
001Jooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0;oooool2o`0005[ooooo001H
ooooo`;o0000<_ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool06oooool00ol0003oooooooooo`0`ooooo`;o0000F?ooool005Kooooo0_l0000coooo
o`03o`000?oooooooooo01cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Moooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool0EOooool005Cooooo0_l0000cooooo`;o
00008?ooool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00[ooooo00Co0000oooo
oooooooo00008Oooool2o`0003;ooooo0_l0001Eooooo`00D_ooool2o`0003Cooooo00?o0000oooo
ooooool08Oooool2o`0000gooooo00?o0000ooooooooool02oooool2o`0002Cooooo00?o0000oooo
ooooool0<Oooool2o`0005?ooooo001@ooooo`;o0000=Oooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooo000000gooooo00?o0000ooooooooool03?ooool2o`0002Cooooo00?o0000oooooooo
ool0<_ooool00ol0003oooooooooo`1@ooooo`00Coooool00ol0003oooooooooo`0cooooo`;o0000
8oooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00_ooooo00Co0000oooooooo
oooo00009?ooool00ol0003oooooooooo`0booooo`;o0000D?ooool004gooooo0_l0000eooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Rooooo`;o
0000=?ooool2o`0004kooooo001;ooooo`;o0000=_ooool00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo00Cooooo00Co0000oooooooooooooooo0ol00005ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo03?o
oooo00?o0000ooooooooool0Boooool004[ooooo00?o0000ooooooooool0=Oooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo00Kooooo00Go0000ooooooooooooooooo`000006ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Sooooo`03
o`000?oooooooooo03?ooooo0_l0001;ooooo`00B?ooool2o`0003Kooooo0_l0000Tooooo`03o`00
0?oooooooooo00Sooooo1Ol00005ooooo`Co00001_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo02?ooooo00?o0000ooooooooool0=?ooool00ol0003oooooooooo`18ooooo`00A_oo
ool2o`0003Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`09ooooo`;o000000?o
ooooo`000?ooool01Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool08oooool2o`0003Gooooo0_l00018ooooo`00AOooool00ol0003oooooooooo`0f
ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0003oooooo`000006
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0T
ooooo`03o`000?oooooooooo03Cooooo0_l00016ooooo`00@oooool2o`0003Oooooo0_l0000Uoooo
o`03o`000?oooooooooo00gooooo0_l00006ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo03Gooooo00?o0000oooo
ooooool0@oooool004;ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0Tooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool09?ooool2o`0003Kooooo0_l00013ooooo`00
@?ooool2o`0003Oooooo0_l0000Vooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
9Oooool00ol0003oooooooooo`0eooooo`;o0000@Oooool003oooooo00?o0000ooooooooool0=_oo
ool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool09Ooo
ool2o`0003Oooooo0_l0000oooooo`00?Oooool2o`0003Sooooo00?o0000ooooooooool09Oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0=_ooool2
o`0003gooooo000kooooo`;o0000>?ooool2o`0002Oooooo00?o0000ooooooooool05_ooool01Ol0
003ooooooooooooooooo000000?ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0V
ooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool0>_ooool003[ooooo00?o0000oooo
ooooool0=oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo01Sooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`0Hooooo`;o00009oooool2o`0003Sooooo0_l0000j
ooooo`00>?ooool2o`0003Wooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0Joooo
o`05o`000?oooooo0000ooooool000007Oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooo
oooo03Oooooo0_l0000hooooo`00=oooool00ol0003oooooooooo`0gooooo`;o0000:?ooool00ol0
003oooooooooo`0Looooo`?o00007oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
03Sooooo0_l0000fooooo`00=Oooool2o`0003Wooooo00?o0000ooooooooool09oooool00ol0003o
ooooooooo`0Nooooo`?o00007oooool00ol0003oooooooooo`0Vooooo`;o0000>_ooool2o`0003Co
oooo000cooooo`;o0000>_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01oooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo03Wooooo
0_l0000booooo`00<Oooool2o`0003[ooooo0_l0000Yooooo`03o`000?oooooooooo01oooooo0ol0
000Rooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0>_ooool00ol0003ooooooooo
o`0_ooooo`00;oooool2o`0003_ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0O
ooooo`05o`000?oooooo0000ooooool000008_ooool00ol0003oooooooooo`0Wooooo`;o0000>ooo
ool2o`0002oooooo000^ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool0:?ooool0
0ol0003oooooooooo`0Oooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool08?oo
ool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo03[ooooo0_l0000]ooooo`00;?ooool2
o`0003_ooooo0_l0000Zooooo`03o`000?oooooooooo01oooooo00Go0000ooooooooooooooooo`00
0003ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0:?ooool2o`0003cooooo00?o
0000ooooooooool0:_ooool002[ooooo0_l0000looooo`03o`000?oooooooooo02Wooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool08?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo03[ooooo0_l0000Z
ooooo`00:?ooool2o`0003gooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0Ooooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Poooo
o`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0>oooool2o`0002Sooooo000Vooooo`;o
0000?Oooool2o`0002_ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Yooooo`;o
0000?Oooool00ol0003oooooooooo`0Uooooo`009?ooool2o`0003kooooo00?o0000ooooooooool0
:_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0
>oooool2o`0002Gooooo000Sooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0:_oo
ool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0??oo
ool2o`0002?ooooo000Rooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0:_ooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0?Oooool0
0ol0003oooooooooo`0Pooooo`00\
\>"],
  ImageRangeCache->{{{0, 375.75}, {231.875, 0}} -> {-3.15479, -5.00005, \
0.0167919, 0.0431268}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A singular solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The above plot certainly suggests that there is some curve(an envelope) to \
which each of the straight lines is tangent at one point. This curve is given \
by the parametric representation described above. \nIt is: ",
  StyleBox["{-f'[t],f[t]-t*f'[t]}, ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "where f[t]=(1/2)t^2",
  StyleBox[".",
    FontFamily->"Courier"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[t_] = t\^2\/2\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(t\^2\/2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"curve", "=", 
      RowBox[{"ParametricPlot", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], ",", 
              RowBox[{\(f[t]\), "-", 
                RowBox[{"t", " ", 
                  RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}], 
          ",", \({t, \(-3\), 3}\), 
          ",", \(PlotStyle \[Rule] {RGBColor[1, 0, 0], Thickness[ .008]}\)}], 
        "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.603319 0.130801 [
[.02381 .59082 -6 -9 ]
[.02381 .59082 6 0 ]
[.18254 .59082 -6 -9 ]
[.18254 .59082 6 0 ]
[.34127 .59082 -6 -9 ]
[.34127 .59082 6 0 ]
[.65873 .59082 -3 -9 ]
[.65873 .59082 3 0 ]
[.81746 .59082 -3 -9 ]
[.81746 .59082 3 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.4875 .08012 -12 -4.5 ]
[.4875 .08012 0 4.5 ]
[.4875 .21092 -12 -4.5 ]
[.4875 .21092 0 4.5 ]
[.4875 .34172 -12 -4.5 ]
[.4875 .34172 0 4.5 ]
[.4875 .47252 -12 -4.5 ]
[.4875 .47252 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .60332 m
.02381 .60957 L
s
[(-3)] .02381 .59082 0 1 Mshowa
.18254 .60332 m
.18254 .60957 L
s
[(-2)] .18254 .59082 0 1 Mshowa
.34127 .60332 m
.34127 .60957 L
s
[(-1)] .34127 .59082 0 1 Mshowa
.65873 .60332 m
.65873 .60957 L
s
[(1)] .65873 .59082 0 1 Mshowa
.81746 .60332 m
.81746 .60957 L
s
[(2)] .81746 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(3)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.05556 .60332 m
.05556 .60707 L
s
.0873 .60332 m
.0873 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.15079 .60332 m
.15079 .60707 L
s
.21429 .60332 m
.21429 .60707 L
s
.24603 .60332 m
.24603 .60707 L
s
.27778 .60332 m
.27778 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.37302 .60332 m
.37302 .60707 L
s
.40476 .60332 m
.40476 .60707 L
s
.43651 .60332 m
.43651 .60707 L
s
.46825 .60332 m
.46825 .60707 L
s
.53175 .60332 m
.53175 .60707 L
s
.56349 .60332 m
.56349 .60707 L
s
.59524 .60332 m
.59524 .60707 L
s
.62698 .60332 m
.62698 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.72222 .60332 m
.72222 .60707 L
s
.75397 .60332 m
.75397 .60707 L
s
.78571 .60332 m
.78571 .60707 L
s
.84921 .60332 m
.84921 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.9127 .60332 m
.9127 .60707 L
s
.94444 .60332 m
.94444 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.5 .08012 m
.50625 .08012 L
s
[(-4)] .4875 .08012 1 0 Mshowa
.5 .21092 m
.50625 .21092 L
s
[(-3)] .4875 .21092 1 0 Mshowa
.5 .34172 m
.50625 .34172 L
s
[(-2)] .4875 .34172 1 0 Mshowa
.5 .47252 m
.50625 .47252 L
s
[(-1)] .4875 .47252 1 0 Mshowa
.125 Mabswid
.5 .10628 m
.50375 .10628 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1586 m
.50375 .1586 L
s
.5 .18476 m
.50375 .18476 L
s
.5 .23708 m
.50375 .23708 L
s
.5 .26324 m
.50375 .26324 L
s
.5 .2894 m
.50375 .2894 L
s
.5 .31556 m
.50375 .31556 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39404 m
.50375 .39404 L
s
.5 .4202 m
.50375 .4202 L
s
.5 .44636 m
.50375 .44636 L
s
.5 .49868 m
.50375 .49868 L
s
.5 .52484 m
.50375 .52484 L
s
.5 .551 m
.50375 .551 L
s
.5 .57716 m
.50375 .57716 L
s
.5 .05396 m
.50375 .05396 L
s
.5 .0278 m
.50375 .0278 L
s
.5 .00163 m
.50375 .00163 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.97619 .01472 m
.93756 .10635 L
.89542 .19746 L
.85585 .27463 L
.81779 .34117 L
.77728 .40374 L
.73829 .45593 L
.69684 .50274 L
.65691 .53941 L
.6185 .56687 L
.59905 .57785 L
.57763 .58767 L
.55732 .59479 L
.54822 .59728 L
.53828 .59951 L
.5329 .60051 L
.5279 .6013 L
.52273 .60198 L
.51804 .60247 L
.51342 .60285 L
.5113 .60299 L
.50907 .60311 L
.50668 .6032 L
.50562 .60324 L
.50448 .60327 L
.50325 .60329 L
.50211 .60331 L
.50141 .60331 L
.50075 .60332 L
.49951 .60332 L
.49837 .60331 L
.49714 .6033 L
.49599 .60328 L
.49492 .60325 L
.49246 .60317 L
.48986 .60305 L
.48732 .6029 L
.48496 .60273 L
.4796 .60224 L
.4707 .60109 L
.46118 .59941 L
.45094 .59707 L
.43984 .59392 L
.41968 .58657 L
.39981 .57726 L
.37877 .56517 L
.34088 .5376 L
.30054 .50005 L
.26171 .45593 L
.22044 .40045 L
Mistroke
.18068 .33864 L
.14243 .27144 L
.10173 .19159 L
.06255 .1066 L
.02381 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.438, 173.875},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[B000`400?l00000o`00003oS?ooool2
o`0008_ooooo002<ooooo`03o`000?oooooooooo08[ooooo002<ooooo`03o`000?oooooooooo08[o
oooo002<ooooo`03o`000?oooooooooo08[ooooo0006ooooo`;oo`00Q?ooool00ol0003ooooooooo
o`21ooooo`;oo`001oooool000Kooooo0_oo0024ooooo`03o`000?oooooooooo087ooooo0_oo0007
ooooo`001_ooool3ool008?ooooo00?o0000ooooooooool0P?ooool3ool000Oooooo0007ooooo`;o
o`00Poooool2o`00087ooooo0_oo0008ooooo`001oooool2ool008?ooooo00?o0000ooooooooool0
Ooooool3ool000Sooooo0007ooooo`?oo`00P_ooool00ol0003oooooooooo`1oooooo`;oo`002Ooo
ool000Sooooo0_oo0022ooooo`03o`000?oooooooooo07oooooo0_oo0009ooooo`002?ooool3ool0
087ooooo00?o0000ooooooooool0O_ooool3ool000Wooooo0009ooooo`;oo`00POooool00ol0003o
ooooooooo`1nooooo`;oo`002_ooool000Wooooo0_oo0021ooooo`03o`000?oooooooooo07gooooo
0ooo000:ooooo`002Oooool3ool0083ooooo00?o0000ooooooooool0OOooool2ool000_ooooo000:
ooooo`;oo`00P?ooool2o`0007gooooo0ooo000;ooooo`002_ooool3ool007oooooo00?o0000oooo
ooooool0O?ooool2ool000cooooo000;ooooo`;oo`00Ooooool00ol0003oooooooooo`1kooooo`?o
o`003?ooool000_ooooo0_oo001oooooo`03o`000?oooooooooo07_ooooo0_oo000=ooooo`002ooo
ool3ool007kooooo00?o0000ooooooooool0Noooool2ool000gooooo000<ooooo`;oo`00M_ooool3
o`0000Gooooo00?o0000ooooooooool0N_ooool3ool000gooooo000<ooooo`?oo`00M_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo07[ooooo0_oo000>ooooo`003Oooool2ool006go
oooo1Ol000000ooooooo0000o`000003o`0000Gooooo0_l0001jooooo`?oo`003_ooool000gooooo
0_oo001cooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool0NOooool2ool000oo
oooo000=ooooo`?oo`00Loooool00ol0003oooooo`000006ooooo`03o`000?oooooooooo07Sooooo
0ooo000?ooooo`003_ooool2ool007Cooooo0_l00006ooooo`03o`000?oooooooooo07Sooooo0_oo
000@ooooo`003_ooool3ool007Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1h
ooooo`;oo`004?ooool000oooooo0_oo001kooooo`03o`000?oooooooooo07Oooooo0ooo000@oooo
o`003oooool2ool007_ooooo00?o0000ooooooooool0Moooool2ool0017ooooo000?ooooo`?oo`00
N_ooool2o`0007Oooooo0ooo000Aooooo`004?ooool2ool007[ooooo00?o0000ooooooooool0M_oo
ool2ool001;ooooo000@ooooo`?oo`00NOooool00ol0003oooooooooo`1eooooo`?oo`004_ooool0
017ooooo0_oo001iooooo`03o`000?oooooooooo07Gooooo0_oo000Cooooo`004Oooool3ool007So
oooo00?o0000ooooooooool0M?ooool3ool001?ooooo000Booooo`;oo`00N?ooool00ol0003ooooo
ooooo`1dooooo`;oo`005?ooool001;ooooo0ooo001gooooo`03o`000?oooooooooo07?ooooo0ooo
000Dooooo`004oooool2ool007Oooooo00?o0000ooooooooool0Loooool2ool001Gooooo000Coooo
o`;oo`00Moooool2o`0007Cooooo0_oo000Eooooo`004oooool3ool007Kooooo00?o0000oooooooo
ool0L_ooool3ool001Gooooo000Dooooo`;oo`00M_ooool00ol0003oooooooooo`1booooo`;oo`00
5_ooool001Cooooo0ooo001eooooo`03o`000?oooooooooo077ooooo0ooo000Fooooo`005Oooool2
ool007Gooooo00?o0000ooooooooool0LOooool2ool001Oooooo000Eooooo`?oo`00M?ooool00ol0
003oooooooooo`1`ooooo`?oo`005oooool001Kooooo0_oo001dooooo`03o`000?oooooooooo073o
oooo0_oo000Hooooo`005_ooool3ool007?ooooo0_l0001`ooooo`?oo`006?ooool001Oooooo0_oo
001cooooo`03o`000?oooooooooo06oooooo0_oo000Iooooo`005oooool3ool007;ooooo00?o0000
ooooooooool0K_ooool3ool001Wooooo000Hooooo`;oo`00L_ooool00ol0003oooooooooo`1^oooo
o`;oo`006_ooool001Sooooo0_oo001booooo`03o`000?oooooooooo06gooooo0ooo000Jooooo`00
6?ooool3ool0077ooooo00?o0000ooooooooool0KOooool2ool001_ooooo000Iooooo`;oo`00LOoo
ool00ol0003oooooooooo`1]ooooo`;oo`006oooool001Wooooo0ooo001`ooooo`;o0000KOooool3
ool001_ooooo000Jooooo`;oo`00L?ooool00ol0003oooooooooo`1/ooooo`;oo`007?ooool001[o
oooo0ooo001_ooooo`03o`000?oooooooooo06_ooooo0ooo000Looooo`006oooool2ool006oooooo
00?o0000ooooooooool0Joooool2ool001gooooo000Kooooo`?oo`00K_ooool00ol0003ooooooooo
o`1Zooooo`?oo`007Oooool001cooooo0_oo001Uooooo`?o00001_ooool00ol0003oooooooooo`1Z
ooooo`;oo`007_ooool001cooooo0ooo001Sooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`1Yooooo`?oo`007_ooool001gooooo0_oo001Mooooo`Go00001Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo06Wooooo0_oo000Oooooo`007Oooool3ool006Co
oooo0_l00006ooooo`;o0000JOooool3ool001oooooo000Nooooo`;oo`00I_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo06Sooooo0_oo000Pooooo`007_ooool3ool0067ooooo00Go
0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo06Oooooo0ooo000Pooooo`007ooo
ool2ool006;ooooo0ol00006ooooo`03o`000?oooooooooo06Oooooo0_oo000Qooooo`007oooool3
ool006[ooooo00?o0000ooooooooool0I_ooool3ool0027ooooo000Pooooo`;oo`00J_ooool00ol0
003oooooooooo`1Vooooo`;oo`008_ooool0023ooooo0ooo001Yooooo`03o`000?oooooooooo06Go
oooo0ooo000Rooooo`008Oooool3ool006Sooooo0_l0001Uooooo`?oo`008oooool002;ooooo0_oo
001Xooooo`03o`000?oooooooooo06Cooooo0_oo000Tooooo`008_ooool3ool006Oooooo00?o0000
ooooooooool0Hoooool3ool002Cooooo000Sooooo`;oo`00Ioooool00ol0003oooooooooo`1Soooo
o`;oo`009Oooool002?ooooo0ooo001Vooooo`03o`000?oooooooooo06;ooooo0ooo000Uooooo`00
9?ooool2ool006Kooooo00?o0000ooooooooool0H_ooool2ool002Kooooo000Tooooo`?oo`00IOoo
ool00ol0003oooooooooo`1Qooooo`?oo`009_ooool002Gooooo0_oo001Uooooo`;o0000H_ooool2
ool002Oooooo000Uooooo`?oo`00I?ooool00ol0003oooooooooo`1Pooooo`?oo`009oooool002Ko
oooo0_oo001Tooooo`03o`000?oooooooooo063ooooo0_oo000Xooooo`009_ooool3ool006?ooooo
00?o0000ooooooooool0Goooool3ool002Sooooo000Wooooo`;oo`00Hoooool00ol0003ooooooooo
o`1Oooooo`;oo`00:Oooool002Oooooo0ooo001Rooooo`03o`000?oooooooooo05kooooo0ooo000Y
ooooo`00:?ooool2ool006;ooooo00?o0000ooooooooool0G_ooool2ool002[ooooo000Xooooo`?o
o`00HOooool00ol0003oooooooooo`1Mooooo`?oo`00:_ooool002Wooooo0ooo001Pooooo`;o0000
G_ooool2ool002_ooooo000Zooooo`;oo`00H?ooool00ol0003oooooooooo`1Looooo`?oo`00:ooo
ool002[ooooo0ooo001Oooooo`03o`000?oooooooooo05cooooo0_oo000/ooooo`00:oooool2ool0
05oooooo00?o0000ooooooooool0Foooool3ool002cooooo000[ooooo`?oo`00G_ooool00ol0003o
ooooooooo`1Kooooo`;oo`00;Oooool002cooooo0_oo001Nooooo`03o`000?oooooooooo05[ooooo
0ooo000]ooooo`00;?ooool3ool005gooooo00?o0000ooooooooool0FOooool3ool002kooooo000]
ooooo`;oo`00GOooool2o`0005[ooooo0_oo000_ooooo`00;Oooool3ool005cooooo00?o0000oooo
ooooool0F?ooool3ool002oooooo000^ooooo`?oo`00Foooool00ol0003oooooooooo`1Hooooo`;o
o`00<?ooool002oooooo0_oo001Kooooo`03o`000?oooooooooo05Oooooo0ooo000`ooooo`00;ooo
ool3ool005[ooooo00?o0000ooooooooool0Eoooool2ool0037ooooo000`ooooo`;oo`00D?ooool5
o`0000Gooooo00?o0000ooooooooool0E_ooool3ool0037ooooo000`ooooo`?oo`00D?ooool01?l0
003oooooooooool00005ooooo`03o`000?oooooooooo05Kooooo0_oo000booooo`00<Oooool2ool0
04Wooooo1Ol00003ooooo`03o`000?oooooooooo00Gooooo0_l0001Fooooo`?oo`00<_ooool0037o
oooo0ooo001Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0EOooool2ool003?o
oooo000booooo`?oo`00COooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000oooooooo
ool0E?ooool3ool003?ooooo000cooooo`;oo`00COooool01Ol0003ooooooooooooooooo000000Go
oooo00?o0000ooooooooool0Doooool3ool003Cooooo000cooooo`?oo`00COooool3o`0000Kooooo
00?o0000ooooooooool0Doooool2ool003Gooooo000dooooo`?oo`00EOooool00ol0003ooooooooo
o`1Booooo`?oo`00=Oooool003Gooooo0_oo001Eooooo`03o`000?oooooooooo057ooooo0ooo000f
ooooo`00=Oooool3ool005Cooooo00?o0000ooooooooool0DOooool2ool003Oooooo000fooooo`?o
o`00Doooool2o`00057ooooo0ooo000gooooo`00=oooool2ool005?ooooo00?o0000ooooooooool0
Coooool3ool003Sooooo000gooooo`?oo`00D_ooool00ol0003oooooooooo`1?ooooo`;oo`00>Ooo
ool003Sooooo0ooo001Aooooo`03o`000?oooooooooo04kooooo0ooo000iooooo`00>Oooool2ool0
057ooooo00?o0000ooooooooool0COooool3ool003[ooooo000iooooo`?oo`00D?ooool00ol0003o
ooooooooo`1=ooooo`;oo`00>oooool003[ooooo0ooo001?ooooo`03o`000?oooooooooo04cooooo
0ooo000kooooo`00>oooool2ool004oooooo0_l0001<ooooo`?oo`00??ooool003_ooooo0ooo001>
ooooo`03o`000?oooooooooo04_ooooo0_oo000mooooo`00??ooool3ool004gooooo00?o0000oooo
ooooool0B_ooool3ool003gooooo000mooooo`;oo`00COooool00ol0003oooooooooo`19ooooo`?o
o`00?_ooool003gooooo0ooo001<ooooo`03o`000?oooooooooo04Wooooo0_oo000oooooo`00?_oo
ool3ool004_ooooo00?o0000ooooooooool0B?ooool3ool003oooooo000oooooo`?oo`00B_ooool0
0ol0003oooooooooo`17ooooo`?oo`00@?ooool0043ooooo0_oo001:ooooo`;o0000Aoooool3ool0
047ooooo0010ooooo`?oo`00BOooool00ol0003oooooooooo`15ooooo`?oo`00@_ooool0047ooooo
0ooo0018ooooo`03o`000?oooooooooo04Gooooo0_oo0013ooooo`00@_ooool3ool004Oooooo00?o
0000ooooooooool0A?ooool3ool004?ooooo0013ooooo`;oo`00Aoooool00ol0003oooooooooo`13
ooooo`?oo`00A?ooool004?ooooo0ooo0016ooooo`03o`000?oooooooooo04;ooooo0ooo0015oooo
o`00A?ooool3ool004Gooooo00?o0000ooooooooool0@_ooool2ool004Kooooo0015ooooo`;oo`00
AOooool2o`0004;ooooo0ooo0016ooooo`00AOooool3ool004Cooooo00?o0000ooooooooool0@?oo
ool3ool004Oooooo0016ooooo`?oo`00@oooool00ol0003oooooooooo`0oooooo`?oo`00B?ooool0
04Oooooo0ooo0012ooooo`03o`000?oooooooooo03kooooo0ooo0019ooooo`00B?ooool2ool004;o
oooo00?o0000ooooooooool0?_ooool2ool004[ooooo0018ooooo`?oo`00>?ooool3o`0000Kooooo
00?o0000ooooooooool0?Oooool3ool004[ooooo0019ooooo`?oo`00>?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo03cooooo0ooo001;ooooo`00B_ooool3ool002oooooo1Ol00003
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0>oooool3ool004cooooo001;oooo
o`?oo`00=_ooool00ol0003oooooooooo`05ooooo`;o0000>oooool3ool004gooooo001<ooooo`?o
o`00=Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03Wooooo0ooo001>ooooo`00
COooool3ool003?ooooo0_l00007ooooo`03o`000?oooooooooo03Sooooo0ooo001?ooooo`00C_oo
ool3ool003?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0hooooo`;oo`00D?oo
ool004oooooo0ooo000jooooo`03o`000?oooooooooo03Oooooo0ooo001@ooooo`00D?ooool3ool0
03Wooooo00?o0000ooooooooool0=_ooool3ool0057ooooo001Aooooo`?oo`00>?ooool00ol0003o
ooooooooo`0eooooo`?oo`00D_ooool005;ooooo0ooo000gooooo`;o0000=Oooool3ool005?ooooo
001Cooooo`?oo`00=_ooool00ol0003oooooooooo`0cooooo`?oo`00E?ooool005Cooooo0ooo000e
ooooo`03o`000?oooooooooo03;ooooo0ooo001Eooooo`00EOooool3ool003Cooooo00?o0000oooo
ooooool0<Oooool3ool005Kooooo001Fooooo`?oo`00<oooool00ol0003oooooooooo`0`ooooo`?o
o`00Eoooool005Oooooo0ooo000booooo`03o`000?oooooooooo02oooooo0ooo001Hooooo`00F?oo
ool3ool0037ooooo00?o0000ooooooooool0;_ooool3ool005Wooooo001Iooooo`?oo`00<?ooool2
o`0002kooooo0ooo001Jooooo`00F_ooool3ool002oooooo00?o0000ooooooooool0;?ooool3ool0
05_ooooo001Kooooo`?oo`00;_ooool00ol0003oooooooooo`0[ooooo`?oo`00G?ooool005cooooo
0ooo000]ooooo`03o`000?oooooooooo02[ooooo0ooo001Mooooo`00GOooool4ool002_ooooo00?o
0000ooooooooool0:Oooool3ool005kooooo001Nooooo`Coo`00:_ooool00ol0003oooooooooo`0W
ooooo`Coo`00Goooool0063ooooo0ooo000Yooooo`03o`000?oooooooooo02Kooooo1?oo001Poooo
o`00HOooool4ool002Oooooo00?o0000ooooooooool09?ooool4ool006;ooooo001Rooooo`Coo`00
9_ooool2o`0002?ooooo1Ooo001Sooooo`00I?ooool4ool002Cooooo00?o0000ooooooooool08Ooo
ool4ool006Gooooo001Uooooo`Coo`008oooool00ol0003oooooooooo`0Oooooo`Coo`00Ioooool0
00Sooooo0ol0000Xooooo`Go0000:?ooool3o`0000Cooooo0ooo000Rooooo`03o`000?oooooooooo
01kooooo1?oo0005ooooo`?o0000:Oooool5o`0002Sooooo0ol00007ooooo`001oooool01Ol0003o
oooooooooooooooo000002Sooooo00Co0000oooooooooooo0000:Oooool00ol0003oooooooooo`04
ooooo`Coo`008?ooool00ol0003oooooooooo`0Looooo`Coo`002?ooool00ol0003oooooooooo`0Y
ooooo`04o`000?ooooooooooo`0002Oooooo00Go0000ooooooooooooooooo`000006ooooo`0000?o
ooooo`000?l000000ol00005ooooo`03o`000?oooooooooo01oooooo1Ol00003ooooo`03o`000?oo
oooooooo027ooooo1Ol00003ooooo`03o`000?oooooooooo00Gooooo1Ooo000Nooooo`03o`000?oo
oooooooo01[ooooo1Ooo0009ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0:ooo
ool00ol0003oooooooooo`04ooooo`002Oooool2o`0002_ooooo00?o0000ooooooooool0:?ooool0
0ol0003oooooooooo`07ooooo`Goo`007?ooool00ol0003oooooooooo`0Hooooo`Goo`002oooool0
0ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02Sooooo0_l00007ooooo`002oooool00ol0
003oooooooooo`0Uooooo`05o`000?ooooooooooooooool00000:Oooool00ol0003oooooooooo`09
ooooo`Goo`006_ooool2o`0001Oooooo1Ooo000=ooooo`03o`000?oooooooooo02Sooooo00Go0000
ooooooooooooooooo`00000[ooooo`03o`000?oooooooooo00Cooooo0007ooooo`05o`000?oooooo
ooooooooool000009oooool01Ol0003ooooooooooooooooo000002Sooooo0_l0000=ooooo`Goo`00
6?ooool00ol0003oooooooooo`0Dooooo`Goo`003_ooool2o`0002[ooooo00Go0000oooooooooooo
ooooo`00000Wooooo`05o`000?ooooooooooooooool000001_ooool000Sooooo0ol0000Yooooo`?o
0000:_ooool00ol0003oooooooooo`0=ooooo`Coo`005oooool00ol0003oooooooooo`0Booooo`Go
o`004Oooool00ol0003oooooooooo`0Yooooo`?o0000:Oooool3o`0000Oooooo001cooooo`Goo`00
5?ooool00ol0003oooooooooo`0@ooooo`Goo`00MOooool007Cooooo1ooo000Aooooo`03o`000?oo
oooooooo00gooooo1_oo001gooooo`00Moooool7ool000kooooo00?o0000ooooooooool02oooool6
ool007Wooooo001jooooo`[oo`002?ooool00ol0003oooooooooo`06ooooo`Soo`00O?ooool007go
00007_oo001no`0000001oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo
4ooo0007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool000Oooooo00?o
0000ooooooooool0:Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo02[ooooo00?o
0000ooooooooool0:Oooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo02Wooooo00?o
0000ooooooooool01Oooool008cooooo00?o0000ooooooooool0R_ooool008cooooo00?o0000oooo
ooooool0R_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.438}, {172.875, 0}} -> {-3.15812, -4.61252, \
0.0225228, 0.027332}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Both on one set of axes"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[lines, curve]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.0618034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .0618 -12 -4.5 ]
[.4875 .0618 0 4.5 ]
[.4875 .18541 -12 -4.5 ]
[.4875 .18541 0 4.5 ]
[.4875 .43262 -6 -4.5 ]
[.4875 .43262 0 4.5 ]
[.4875 .55623 -6 -4.5 ]
[.4875 .55623 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .0618 m
.50625 .0618 L
s
[(-4)] .4875 .0618 1 0 Mshowa
.5 .18541 m
.50625 .18541 L
s
[(-2)] .4875 .18541 1 0 Mshowa
.5 .43262 m
.50625 .43262 L
s
[(2)] .4875 .43262 1 0 Mshowa
.5 .55623 m
.50625 .55623 L
s
[(4)] .4875 .55623 1 0 Mshowa
.125 Mabswid
.5 .09271 m
.50375 .09271 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .15451 m
.50375 .15451 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .46353 m
.50375 .46353 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .58713 m
.50375 .58713 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.47354 .61803 m
.49955 .58766 L
.53984 .5406 L
.57861 .49531 L
.61984 .44715 L
.65954 .40077 L
.69774 .35616 L
.73838 .30868 L
.77751 .26297 L
.81909 .2144 L
.85916 .1676 L
.89771 .12257 L
.93871 .07468 L
.97619 .0309 L
s
.38095 .61803 m
.3815 .6175 L
.42237 .57772 L
.46172 .53942 L
.49955 .50259 L
.53984 .46337 L
.57861 .42563 L
.61984 .3855 L
.65954 .34685 L
.69774 .30967 L
.73838 .27011 L
.77751 .23202 L
.81909 .19155 L
.85916 .15254 L
.89771 .11502 L
.93871 .07511 L
.97619 .03863 L
s
.2619 .61803 m
.30316 .58591 L
.34309 .55482 L
.3815 .5249 L
.42237 .49308 L
.46172 .46244 L
.49955 .43297 L
.53984 .4016 L
.57861 .37141 L
.61984 .33931 L
.65954 .30838 L
.69774 .27864 L
.73838 .24699 L
.77751 .21652 L
.81909 .18414 L
.85916 .15294 L
.89771 .12292 L
.93871 .09099 L
.97619 .0618 L
s
.08995 .61803 m
.10458 .60949 L
.14415 .58638 L
.18221 .56415 L
.22272 .54049 L
.26171 .51772 L
.30316 .49351 L
.34309 .47019 L
.3815 .44776 L
.42237 .42389 L
.46172 .4009 L
.49955 .37881 L
.53984 .35528 L
.57861 .33263 L
.61984 .30856 L
.65954 .28537 L
.69774 .26306 L
.73838 .23932 L
.77751 .21647 L
.81909 .19218 L
.85916 .16878 L
.89771 .14627 L
.93871 .12232 L
.97619 .10043 L
s
.02381 .52533 m
.06244 .51029 L
.10458 .49388 L
.14415 .47847 L
.18221 .46365 L
.22272 .44788 L
.26171 .4327 L
.30316 .41656 L
.34309 .40102 L
.3815 .38606 L
.42237 .37015 L
.46172 .35482 L
.49955 .34009 L
.53984 .32441 L
.57861 .30931 L
.61984 .29326 L
.65954 .2778 L
.69774 .26293 L
.73838 .2471 L
.77751 .23187 L
.81909 .21568 L
.85916 .20008 L
.89771 .18507 L
.93871 .1691 L
.97619 .15451 L
s
.02381 .40945 m
.06244 .40193 L
.10458 .39372 L
.14415 .38602 L
.18221 .37861 L
.22272 .37072 L
.26171 .36313 L
.30316 .35506 L
.34309 .34729 L
.3815 .33981 L
.42237 .33186 L
.46172 .3242 L
.49955 .31683 L
.53984 .30899 L
.57861 .30144 L
.61984 .29341 L
.65954 .28568 L
.69774 .27825 L
.73838 .27033 L
.77751 .26272 L
.81909 .25462 L
.85916 .24682 L
.89771 .23932 L
.93871 .23133 L
.97619 .22404 L
s
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.02381 .22404 m
.06244 .23156 L
.10458 .23976 L
.14415 .24747 L
.18221 .25487 L
.22272 .26276 L
.26171 .27035 L
.30316 .27842 L
.34309 .28619 L
.3815 .29367 L
.42237 .30163 L
.46172 .30929 L
.49955 .31666 L
.53984 .3245 L
.57861 .33205 L
.61984 .34007 L
.65954 .3478 L
.69774 .35524 L
.73838 .36315 L
.77751 .37077 L
.81909 .37886 L
.85916 .38666 L
.89771 .39417 L
.93871 .40215 L
.97619 .40945 L
s
.02381 .15451 m
.06244 .16955 L
.10458 .18596 L
.14415 .20137 L
.18221 .21618 L
.22272 .23196 L
.26171 .24714 L
.30316 .26327 L
.34309 .27882 L
.3815 .29378 L
.42237 .30969 L
.46172 .32501 L
.49955 .33974 L
.53984 .35543 L
.57861 .37053 L
.61984 .38658 L
.65954 .40204 L
.69774 .41691 L
.73838 .43274 L
.77751 .44797 L
.81909 .46416 L
.85916 .47976 L
.89771 .49477 L
.93871 .51074 L
.97619 .52533 L
s
.02381 .10043 m
.06244 .123 L
.10458 .1476 L
.14415 .17072 L
.18221 .19294 L
.22272 .2166 L
.26171 .23937 L
.30316 .26358 L
.34309 .2869 L
.3815 .30934 L
.42237 .3332 L
.46172 .35619 L
.49955 .37828 L
.53984 .40181 L
.57861 .42446 L
.61984 .44853 L
.65954 .47173 L
.69774 .49403 L
.73838 .51777 L
.77751 .54062 L
.81909 .56491 L
.85916 .58831 L
.89771 .61083 L
s
.89771 .61083 m
.91005 .61803 L
s
.02381 .0618 m
.06244 .09189 L
.10458 .1247 L
.14415 .15552 L
.18221 .18515 L
.22272 .2167 L
.26171 .24706 L
.30316 .27934 L
.34309 .31043 L
.3815 .34034 L
.42237 .37217 L
.46172 .40281 L
.49955 .43227 L
.53984 .46365 L
.57861 .49384 L
.61984 .52594 L
.65954 .55686 L
.69774 .58661 L
s
.69774 .58661 m
.7381 .61803 L
s
.02381 .03863 m
.06244 .07623 L
.10458 .11725 L
.14415 .15577 L
.18221 .19281 L
.22272 .23224 L
.26171 .2702 L
.30316 .31054 L
.34309 .34941 L
.3815 .3868 L
.42237 .42658 L
.46172 .46489 L
.49955 .50172 L
.53984 .54093 L
.57861 .57867 L
s
.57861 .57867 m
.61905 .61803 L
s
.02381 .0309 m
.06244 .07603 L
.10458 .12525 L
.14415 .17147 L
.18221 .21592 L
.22272 .26324 L
.26171 .30879 L
.30316 .3572 L
.34309 .40384 L
.3815 .44871 L
.42237 .49645 L
.46172 .54241 L
.49955 .58661 L
s
.49955 .58661 m
.52646 .61803 L
s
1 0 0 r
.008 w
.97619 .0309 m
.93756 .0742 L
.89542 .11725 L
.85585 .15371 L
.81779 .18515 L
.77728 .21472 L
.73829 .23937 L
.69684 .26149 L
.65691 .27882 L
.6185 .29179 L
.59905 .29698 L
.57763 .30162 L
.55732 .30499 L
.54822 .30617 L
.53828 .30722 L
.5329 .30769 L
.5279 .30806 L
.52273 .30838 L
.51804 .30862 L
.51342 .3088 L
.5113 .30886 L
.50907 .30892 L
.50668 .30896 L
.50562 .30898 L
.50448 .30899 L
.50325 .309 L
.50211 .30901 L
.50141 .30901 L
.50075 .30902 L
.49951 .30902 L
.49837 .30901 L
.49714 .30901 L
.49599 .309 L
.49492 .30899 L
.49246 .30895 L
.48986 .30889 L
.48732 .30882 L
.48496 .30874 L
.4796 .30851 L
.4707 .30796 L
.46118 .30717 L
.45094 .30606 L
.43984 .30458 L
.41968 .30111 L
.39981 .29671 L
.37877 .29099 L
.34088 .27796 L
.30054 .26022 L
.26171 .23938 L
.22044 .21316 L
Mistroke
.18068 .18396 L
.14243 .1522 L
.10173 .11448 L
.06255 .07432 L
.02381 .0309 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{303.625, 187.688},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004_0000^b000`400?l00000o`00003oUoooool0
0ol0003oooooooooo`2Eooooo`00Uoooool00ol0003oooooooooo`2Eooooo`00Uoooool00ol0003o
ooooooooo`2Eooooo`00Uoooool00ol0003oooooooooo`2Eooooo`00Uoooool00ol0003ooooooooo
o`2Eooooo`00Uoooool00ol0003oooooooooo`2Eooooo`00Uoooool00ol0003oooooooooo`2Eoooo
o`00Uoooool00ol0003oooooooooo`2Eooooo`00Uoooool00ol0003oooooooooo`2Eooooo`001_oo
ool2ool008oooooo0_l0002=ooooo`;oo`001oooool000Kooooo0_oo002?ooooo`03o`000?oooooo
oooo08cooooo0_oo0007ooooo`001_ooool3ool008kooooo00?o0000ooooooooool0Roooool3ool0
00Oooooo0007ooooo`?oo`00SOooool00ol0003oooooooooo`2:ooooo`?oo`002?ooool000Sooooo
0ooo002<ooooo`03o`000?oooooooooo08Wooooo0ooo0009ooooo`002Oooool3ool008_ooooo00?o
0000ooooooooool0R?ooool3ool000[ooooo000:ooooo`?oo`00R_ooool00ol0003oooooooooo`27
ooooo`?oo`002oooool000_ooooo0ooo0021ooooo`?o00001Oooool00ol0003oooooooooo`26oooo
o`?oo`003?ooool000cooooo0ooo0021ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0QOooool3ool000gooooo0007ooooo`;o00001?ooool3ool007Oooooo1Ol000000ooooooo0000
o`000003o`0000Gooooo0ol00024ooooo`?oo`001Oooool2o`0000Oooooo0009ooooo`03o`000?oo
oooooooo00;ooooo0ooo001looooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool0
Poooool3ool000Gooooo00?o0000ooooooooool01oooool000[ooooo00?o0000ooooooooool00_oo
ool3ool007cooooo00?o0000ooooool000001_ooool00ol0003oooooooooo`22ooooo`?oo`001Ooo
ool00ol0003oooooooooo`08ooooo`002oooool00ol0003oooooooooo`02ooooo`?oo`00O?ooool2
o`0000Kooooo00?o0000ooooooooool0POooool3ool000Cooooo0_l0000;ooooo`003?ooool00ol0
003oooooooooo`02ooooo`?oo`00O?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
083ooooo0ooo0004ooooo`03o`000?oooooooooo00_ooooo000=ooooo`;o00000oooool3ool008;o
oooo00?o0000ooooooooool0Ooooool3ool000Cooooo00?o0000ooooooooool03?ooool000oooooo
00Co0000oooooooooooooooo0ooo0021ooooo`03o`000?oooooooooo07kooooo0ooo0003ooooo`;o
00003oooool0013ooooo00Co0000oooooooooooooooo0ooo0020ooooo`03o`000?oooooooooo07go
oooo0ooo0003ooooo`03o`000?oooooooooo00oooooo000Aooooo`04o`000?ooooooooooooooo`?o
o`00Ooooool00ol0003oooooooooo`1looooo`?oo`000oooool00ol0003oooooooooo`0@ooooo`00
4_ooool01?l0003oooooooooooooool3ool007kooooo00?o0000ooooooooool0Noooool3ool000;o
oooo0_l0000Cooooo`004oooool2o`0000;ooooo0ooo001mooooo`;o0000Noooool3ool00003o`00
0?oooooo000001Gooooo000Eooooo`03o`000?oooooo000000?oo`00O?ooool00ol0003ooooooooo
o`1iooooo`?oo`0000?o0000ooooool000005_ooool000Oooooo0_l0000=ooooo`03o`000?oooooo
000000?oo`00Noooool00ol0003oooooooooo`1hooooo`?oo`0000?o0000ooooool000003_ooool2
o`0000Oooooo0009ooooo`;o00003?ooool3o`0000?oo`00N_ooool00ol0003oooooooooo`1goooo
o`?oo`0000?o0000ooooool000003Oooool2o`0000Wooooo000;ooooo`03o`000?oooooooooo00_o
oooo0_l00003ool007Wooooo00?o0000ooooooooool0M_ooool3ool000?o00003Oooool00ol0003o
ooooooooo`09ooooo`003?ooool2o`0000cooooo0_l00003ool007Sooooo00?o0000ooooooooool0
MOooool3ool00003ooooool0003ooooo00cooooo0_l0000<ooooo`003_ooool2o`0000_ooooo0_l0
0003ool007Oooooo00?o0000ooooooooool0M?ooool3ool00003ooooool0003ooooo00_ooooo0_l0
000>ooooo`004?ooool00ol0003oooooooooo`09ooooo`;o00000ooo001fooooo`03o`000?oooooo
oooo07;ooooo1?oo00000ooooooo0000ooooo`0;ooooo`03o`000?oooooooooo00kooooo000Aoooo
o`;o00002_ooool2o`0000?oo`00MOooool00ol0003oooooooooo`1aooooo`Coo`0000?oooooo`00
0?ooool02_ooool2o`00017ooooo000Cooooo`;o00002Oooool2o`0000?oo`00M?ooool2o`00077o
oooo0ooo00000ooooooo0000o`00000:ooooo`;o00004oooool001Gooooo0_l00008ooooo`03o`00
0?ooooooo`0000;oo`00Loooool00ol0003oooooooooo`1_ooooo`?oo`0000Coooooo`000?oooooo
00002?ooool2o`0001Gooooo000Gooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0ooo001booooo`03o`000?oooooooooo06kooooo0ooo00001?oooooo0000ooooool00008ooooo`03
o`000?oooooooooo01Gooooo000Hooooo`;o00001_ooool00ol0003oooooooooo`03ool0077ooooo
00?o0000ooooooooool0KOooool3ool000;o000000?oooooo`000?ooool01_ooool2o`0001Sooooo
000Jooooo`;o00001Oooool00ol0003oooooooooo`03ool0073ooooo00?o0000ooooooooool0K?oo
ool3ool00004o`000?ooooooooooo`0000Kooooo0_l0000Jooooo`007?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00?oo`00Koooool00ol0003oooooooooo`1[ooooo`?oo`0000Co
0000oooooooooooo00001_ooool00ol0003oooooooooo`0Jooooo`007Oooool2o`0000Cooooo00?o
0000ooooooooool00ooo001^ooooo`03o`000?oooooooooo06[ooooo0ooo00001?l0003ooooooooo
ool00005ooooo`;o00007Oooool001oooooo0_l00003ooooo`03o`000?oooooooooo00?oo`00KOoo
ool00ol0003oooooooooo`1Yooooo`?oo`000oooool00ol0003oooooooooo`02ooooo`;o00007ooo
ool0027ooooo0_l00002ooooo`03o`000?oooooooooo00?oo`00K?ooool00ol0003oooooooooo`1X
ooooo`?oo`000oooool01?l0003oooooooooooooool2o`00027ooooo0007ooooo`;o00006_ooool0
0ol0003oooooo`000003ooooo`Coo`00J_ooool2o`0006Oooooo1?oo0003ooooo`05o`000?oooooo
ooooooooool000006_ooool2o`0000Oooooo0009ooooo`?o00006?ooool3o`0000?ooooo1?oo001Y
ooooo`03o`000?oooooooooo06Gooooo1?oo0003ooooo`03o`000?oooooooooo00;o00006?ooool3
o`0000Wooooo000<ooooo`;o00006?ooool2o`0000Cooooo0ooo001Xooooo`03o`000?oooooooooo
06Cooooo0ooo00001_l0003ooooooooooooooooo0000ooooo`;o00006?ooool2o`0000cooooo000>
ooooo`;o00006?ooool00ol0003oooooooooo`02ooooo`?oo`00Ioooool00ol0003oooooooooo`1S
ooooo`?oo`0000Oo0000ooooooooooooooooo`000?oooooo000001Sooooo0_l0000>ooooo`004?oo
ool3o`0001Kooooo0_l00003ooooo`Coo`00IOooool00ol0003oooooooooo`1Rooooo`?oo`0000Co
0000oooooooooooooooo0ol0000Fooooo`?o00004?ooool001?ooooo0_l0000Eooooo`?o00000_oo
ool4ool006Cooooo00?o0000ooooooooool0HOooool3ool00004o`000?ooooooooooooooo`;o0000
5_ooool2o`0001?ooooo000Eooooo`?o00004oooool01?l0003oooooo`000?l00002ooooo`?oo`00
Hoooool00ol0003oooooooooo`1Pooooo`?oo`0000?o0000ooooooooool00ol0000Dooooo`?o0000
5Oooool001Sooooo0_l0000Aooooo`05o`000?ooooooooooooooool000000_ooool3ool005Sooooo
1Ol00005ooooo`03o`000?oooooooooo05oooooo0ooo00001_l0003oooooooooool0003oooooo`00
01?ooooo0_l0000Hooooo`006_ooool2o`00013ooooo00Co0000oooooooooooooooo0_l000001?oo
ooooo`00ool00?oo001Hooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0G_oo
ool3ool00006o`000?oooooo0000o`000?oooooo00004_ooool2o`0001[ooooo000Looooo`?o0000
3_ooool00ol0003oooooooooo`02ooooo`;o00001?oo001?ooooo`Go00000oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo05cooooo00Co0000ool00?oo003oo`000ol00002ooooo`03
o`000?oooooooooo00kooooo0ol0000Looooo`007oooool2o`0000gooooo00?o0000ooooooooool0
0oooool00ol0003oo`00ool00002ool005Oooooo00?o0000ooooooooool01?ooool3o`0005_ooooo
1?oo0002o`0000Cooooo00?o0000ooooooooool03?ooool2o`0001oooooo000Qooooo`?o00002ooo
ool00ol0003oooooooooo`03ooooo`;o00000ooo001Cooooo`05o`000?ooooooooooooooool00000
1Oooool00ol0003oooooooooo`1Jooooo`Coo`000_l00004ooooo`03o`000?oooooooooo00[ooooo
0ol0000Qooooo`009?ooool2o`0000[ooooo00?o0000ooooooooool01?ooool00ol0003oo`00ool0
0002ool0057ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo05Wooooo
0ooo0002o`0000Gooooo00?o0000ooooooooool02?ooool3o`0002Cooooo000Vooooo`;o00002Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oo003oo`0000;oo`00DOooool3o`0000Kooooo00?o
0000ooooooooool0Eoooool4ool000;o00001Oooool00ol0003oooooooooo`06ooooo`?o00009ooo
ool002Sooooo0ol00007ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo00000_oo001I
ooooo`03o`000?oooooooooo05Kooooo1?oo00000ooooooo0000ooooo`04ooooo`03o`000?oooooo
oooo00Cooooo0ol0000Zooooo`00:oooool3o`0000Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooool00003ool005Oooooo00?o0000ooooooooool0EOooool3ool00003o`000?oooooo0000
00Kooooo00Co0000oooooooooooooooo0ol0000]ooooo`00;_ooool3o`0000?ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooool00003ool005Kooooo00?o0000ooooooooool0Doooool4ool0
00;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02o`00033ooooo000aooooo`?o
000000?oooooo`000?ooool01Oooool00ol0003oooooooooo`03ool005Gooooo00?o0000oooooooo
ool0D_ooool4ool000;ooooo00?o0000ooooooooool01?ooool01?l0003oooooo`000?l0000boooo
o`00=?ooool3o`0000Kooooo00?o0000ooooooooool01?oo001Cooooo`03o`000?oooooooooo057o
oooo0ooo0003ooooo`03o`000?oooooooooo00Cooooo0ol0000dooooo`00=oooool2o`0000Gooooo
00?o0000ooooooooool01?oo001Booooo`;o0000D?ooool4ool000?ooooo00?o0000ooooooooool0
0oooool2o`0003Oooooo000gooooo`03o`000?oooooo000000;o00000oooool01?l0003ooooooooo
ooooool4ool0053ooooo00?o0000ooooooooool0COooool5ool000?ooooo00Co0000oooooooooooo
oooo0ol000000ooooooo0000ooooo`0fooooo`001oooool3o`0002kooooo00Co0000oooooooooooo
oooo0_l00002ooooo`04o`000?ooooooooooooooo`Goo`00C_ooool00ol0003oooooooooo`1<oooo
o`Coo`001?ooool00ol0003oooooooooo`02o`0000?ooooo00?o0000ooooooooool0;?ooool3o`00
00Oooooo000:ooooo`Co0000:oooool00ol0003oooooooooo`02ooooo`;o000000?oooooo`000?oo
ool00oooool4ool004gooooo00?o0000ooooooooool0B_ooool4ool000Gooooo00Co0000ooooool0
003o00001?ooool00ol0003oooooooooo`0Yooooo`Co00002_ooool000kooooo1?l0000Xooooo`03
o`000?oooooooooo00?ooooo0ol00005ooooo`Coo`00Boooool00ol0003oooooooooo`18ooooo`Go
o`001Oooool3o`0000Gooooo00?o0000ooooooooool09_ooool4o`0000kooooo000Booooo`Go0000
9?ooool00ol0003oooooooooo`05ooooo`?o00000oooool5ool004Wooooo00?o0000ooooooooool0
Aoooool4ool000Gooooo0_l00007ooooo`03o`000?oooooooooo02;ooooo1Ol0000Booooo`005ooo
ool6o`0001oooooo00?o0000ooooooooool01_ooool4o`0000;ooooo1?oo0018ooooo`03o`000?oo
oooooooo04Gooooo1?oo00001?l0003oooooooooooooool3o`0000Sooooo00?o0000ooooooooool0
7Oooool6o`0001Oooooo000Mooooo`Go00006oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00?o000000?oooooool00?oo00000_oo0016ooooo`03o`000?oooooooooo04?ooooo1Ooo
0002ooooo`?o000000?oooooo`000?ooool01oooool00ol0003oooooooooo`0Hooooo`Ko00007Ooo
ool002;ooooo1?l0000Gooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool2
o`0000Goo`00A?ooool00ol0003oooooooooo`11ooooo`Goo`001?l00003ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool04_ooool6o`0002?ooooo000Vooooo`Co00005?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo00?o0000ool00?oo00000ooo0012oooo
o`;o0000@?ooool5ool000?o00001Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00kooooo1Ol0000Yooooo`00:_ooool5o`00013ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`05ooooo`03o`000?oo003oo`0000?oo`00@?ooool00ol0003oooooooooo`0mooooo`Go
o`000_l00007ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02oooool4o`0002ko
oooo000_ooooo`Ko00002oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo
00?o0000oooooooo00001?oo000nooooo`03o`000?oooooooooo03cooooo1?oo00000ol0003ooooo
o`000007ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool4o`0003;ooooo
000eooooo`Ko00001_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01Ooo000looooo`03o`000?oooooooooo03[ooooo1?oo00001?l0003ooooooooo
ool00007ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool5o`0003Kooooo
000kooooo`Ko000000?oooooo`000?ooool02?ooool00ol0003oooooooooo`05ooooo`04o`000?oo
ooooooooooooo`Goo`00>_ooool00ol0003oooooooooo`0hooooo`Goo`000oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000001Ol0000kooooo`00@Ooo
ool6o`0000Kooooo00?o0000ooooooooool01Oooool2o`0000?ooooo1Ooo000hooooo`03o`000?oo
oooooooo03Kooooo1Ooo0003ooooo`;o00001oooool00ol0003oooooooooo`04ooooo`Ko0000@Ooo
ool004?ooooo00Co0000oooooooooooooooo1_l000000ooooooo0000ooooo`07ooooo`03o`000?oo
oooooooo00;ooooo1Ooo000fooooo`03o`000?oooooooooo03?ooooo1_oo0004ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooool000001Ol00003ooooo`03o`000?oooooooooo047ooooo0008
ooooo`?o0000;?ooool5o`0000Sooooo00?o0000ooooooooool01_ooool5o`0000Kooooo00?o0000
ooooooooool00oooool5ool000Gooooo0ol0000/ooooo`03o`000?oooooooooo02_ooooo0ol00003
ooooo`Koo`001Oooool00ol0003oooooooooo`04ooooo`Go00002?ooool00ol0003oooooooooo`07
ooooo`Go0000;?ooool3o`0000Oooooo0007ooooo`05o`000?ooooooooooooooool00000;?ooool0
1?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?l0
0003ooooo`03o`000?oooooooooo00Cooooo1Ooo0004ooooo`03o`000?oooooooooo02_ooooo00?o
0000ooooooooool0;?ooool00ol0003oooooooooo`05ool00003o`000?oooooooooo00Cooooo00Co
0000oooooooooooooooo1?l000000ooooooo0000ooooo`09ooooo`03o`000?oooooooooo00Wooooo
00Co0000oooooooooooo0000:oooool01Ol0003ooooooooooooooooo000000Kooooo00000ooooooo
0000o`000003o`0000Gooooo00?o0000ooooooooool08oooool5o`0000?ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo1Ol00006ooooo`03
o`000?oo003oo`0000?oo`000_ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02co
oooo1_oo00000ol0003oooooooooo`05ooooo`Go00001?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`04ooooo`00
2Oooool2o`0002oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Kooooo1Ol00005ooooo`Goo`0000?o0000ooooooooool0:oooool2o`0002_ooooo
1_oo00000ol0003oooooooooo`03ooooo`Go00001oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool0;?ooool2o`0000Oooooo000;ooooo`03o`000?oo
oooooooo02Wooooo00Go0000ooooooooooooooooo`00000<ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooo`000006o`0000Koo`00:oooool00ol0003ooooo
ooooo`0Wooooo`Koo`0000?oooooo`000?l000001_l000000ooooooo0000ooooo`08ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000002oo
oooo00?o0000ooooooooool01?ooool000Oooooo00Go0000ooooooooooooooooo`00000[ooooo`05
o`000?ooooooooooooooool000003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01?ooool3o`0000Ooo`00:?ooool00ol0003oooooooooo`0Toooo
o`Ooo`001Ol00006ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0<ooooo`05o`000?ooooooooooooooool00000:oooool01Ol0003ooooooooooooo
oooo000000Kooooo0008ooooo`?o0000;Oooool3o`0000kooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l00007ool002Gooooo00?o0000
ooooooooool08Oooool7ool000Go00001oooool2o`0000Wooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0=ooooo`?o0000;Oooool3o`0000Oooooo001:ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Woo`008?ooool00ol0003oooooooooo`0Oooooo`Koo`001?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`18oooo
o`00Boooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l00009ooooo`;o
00000oooool;ool001_ooooo00?o0000ooooooooool06oooool00ol0003oo`00ool00004ool000Go
oooo0_l00009ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`19ooooo`00C?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool2o`0000Kooooo2Ooo000Hooooo`03o`000?oooooooooo01Oooooo
2Ooo0005ooooo`;o00002Oooool2o`0000[ooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`1:ooooo`00COooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`06ooooo`;o00002?oo000Dooooo`03o`000?oo
oooooooo013ooooo3Ooo0007ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo04_ooooo001>ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`;o00002Oooool2
o`0000goo`003?ooool00ol0003oooooooooo`09ooooo`ooo`0000?o0000ooooooooool01oooool2
o`0000[ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo04cooooo0022o`0002Woo`00Q?l0000000Oooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool3o`0000Wo
oooo0_l00007ooooo`03o`000?oooooooooo00;ooooo0_l00003ooooo`03o`000?oooooooooo00Co
oooo1?l00005oooooa[oo`001_ooool4o`0000Kooooo00Co0000oooooooooooooooo0_l00003oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooool000002?ooool00ol0003oooooo`000007oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Gooooo0007ooooo`03o`000?oooooooooo02gooooo00?o0000oooooooo
ool05_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool0
00003Oooool00ol0003oooooooooo`0:ooooo`;o00003oooool8o`0000cooooo0_l0000<ooooo`03
o`000?oooooooooo00[ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`05oooo
o`00DOooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02oooool2o`0000cooooo0_l0000<ooooo`Go000000?oooooo`000?l000000_l00009ooooo`;o
00003?ooool2o`0000_ooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool0Coooool005;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`;o0000
3Oooool2o`0000cooooo0ol00003ooooo`Ko00000oooool00ol0003oooooooooo`04ooooo`Co0000
0_ooool3o`0000cooooo0_l0000<ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`1@ooooo`00Doooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`09ooooo`Ko00002Ooo
ool00ol0003oooooooooo`08ooooo`Go00002oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1Aooooo`00Doooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03?ooool2
o`0000?ooooo1_l00006ooooo`?o00001_ooool00ol0003oooooooooo`05ooooo`?o00001Oooool6
o`0000?ooooo0_l0000<ooooo`;o00003Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo05;ooooo001Dooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool2o`00
00_ooooo1_l0000?ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`;o00003_ooool5o`00
00_ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
05?ooooo001Eooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`02ooooo`Ko00001Oooool2o`00017ooooo1?l00003ooooo`;o00003oooool2o`0000Co
oooo1?l00006ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`1Cooooo`00E_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo
1Ol0000=ooooo`03o`000?oooooooooo017ooooo1?l0000@ooooo`03o`000?oooooooooo00Sooooo
1_l0000>ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0E?ooool005Oooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`05ooooo`Co00000_ooool2o`0000oooooo0_l0
000@ooooo`;o000000Coooooo`000?l0003o00003Oooool2o`0000kooooo1_l0000:ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool0EOooool005Oooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`04o`0000Sooooo00?o0000ooooooooool03_ooool2o`0000_ooooo0ol0
00000ooooooo0000ooooo`03ooooo`;o00002Oooool2o`0000oooooo00?o0000ooooooooool01?oo
ool6o`0000?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`1Fooooo`00F?ooool0
0ol0003oooooooooo`09ooooo`Go00003Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00Gooooo0ol00004ooooo`03o`000?oooooooooo00Cooooo0_l00006ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool02oooool6o`0000[ooooo00?o0000ooooooooool0Eoooool0
05Wooooo00?o0000ooooooooool00_ooool6o`0000Cooooo00?o0000ooooooooool03?ooool2o`00
013ooooo0_l00002ooooo`?o00001oooool00ol0003oooooooooo`06ooooo`?o000000?oooooo`00
0?l000004?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo1_l00003oooo
o`03o`000?oooooooooo05Sooooo001Iooooo`Go00002oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00kooooo0ol0000:ooooo`03o`000?oooooooooo00Sooooo0ol0000?ooooo`;o
00003_ooool00ol0003oooooooooo`0:ooooo`Go0000FOooool005Gooooo1?l00002ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0:ooooo`?o0000
0oooool2o`0000Sooooo00?o0000ooooooooool01_ooool2o`0000?ooooo0ol0000;ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04o`0005Gooooo
001Aooooo`Co00001_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00gooooo0_l0
0008ooooo`;o00002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01_ooool2o`0000Sooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo00Gooooo1?l0001Aooooo`00C?ooool5o`0000_ooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00?ooooo0_l0000;
ooooo`;o00001Oooool00ol0003oooooooooo`03ooooo`;o00002oooool2o`0000Gooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00[ooooo1Ol0001<
ooooo`00A_ooool6o`00017ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooo000000;o00003oooool2o`0000?ooooo00Co0000oooooooooooooooo0_l0000?
ooooo`?o000000?oooooo`000?ooool03_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo013ooooo1_l00016ooooo`00@?ooool6o`0001Sooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`0=ooooo`?o00004oooool00ol0003oooooooooo`02o`000003ooooool0003ooooo
01;ooooo0ol0000>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool05oooool6o`00
043ooooo000jooooo`Ko00007oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Wo
oooo0ol00003ooooo`03o`000?oooooooooo017ooooo1Ol0000Cooooo`04o`000?oooooooooooooo
o`?o00002_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01kooooo1_l0000joooo
o`00=?ooool6o`0002Kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`05ooooo`?o
00001oooool00ol0003oooooooooo`0Aooooo`?o00004oooool00ol0003oooooooooo`05ooooo`;o
00001oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02Gooooo1Ol0000eooooo`00
;_ooool6o`0002gooooo00?o0000ooooooooool03Oooool01?l0003oooooooooooooool3o`0000_o
oooo0_l0000?ooooo`;o000000?oooooo`000?ooool00_l0000?ooooo`;o00002_ooool2o`0000Co
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Zooooo`Co0000<Oooool002Wooooo
1Ol0000cooooo`03o`000?oooooooooo00kooooo0ol0000@ooooo`03o`000?oooooooooo00_ooooo
00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool03?ooool4o`00013ooooo00?o0000ooooooooool0;oooool4o`0002gooooo000Uooooo`Co0000
>Oooool00ol0003oooooooooo`0:ooooo`?o000000?oooooo`000?ooool04Oooool00ol0003ooooo
ooooo`08ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`;o00002_ooool00ol0003ooooo
ooooo`0?ooooo`Co00003Oooool00ol0003oooooooooo`0dooooo`Go0000:?ooool0027ooooo1?l0
000nooooo`03o`000?oooooooooo00Oooooo0_l00005ooooo`03o`000?oooooooooo013ooooo0_l0
0006ooooo`;o00001_ooool00ol0003oooooooooo`04ooooo`;o00001_ooool2o`00017ooooo00?o
0000ooooooooool00_ooool3o`0000Wooooo00?o0000ooooooooool0>_ooool6o`0002;ooooo000L
ooooo`Go0000@oooool00ol0003oooooooooo`04ooooo`;o00002?ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`06
ooooo`?o00001Oooool00ol0003oooooooooo`11ooooo`Ko00007?ooool001Kooooo1_l00019oooo
o`03o`000?oooooooooo00?o00002oooool00ol0003oooooooooo`0Aooooo`04o`000?oooooo0000
o`0000Wooooo00?o0000ooooooooool01oooool2o`000003ooooool0003ooooo017ooooo00?o0000
ooooooooool02_ooool3o`000003ooooool0003ooooo04Wooooo1_l0000Fooooo`004?ooool6o`00
053ooooo0_l0000?ooooo`03o`000?oooooooooo013ooooo0ol0000:ooooo`;o00002Oooool3o`00
017ooooo00?o0000ooooooooool03_ooool2o`00053ooooo1_l0000@ooooo`002_ooool6o`0005?o
oooo0ol000000ooooooo0000ooooo`0?ooooo`03o`000?oooooooooo00gooooo0_l00003ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool01?l0003oooooooooooooool2o`00
00kooooo00?o0000ooooooooool03oooool00ol0003oooooo`000002o`0005?ooooo1_l0000:oooo
o`001oooool3o`0005Oooooo0_l00004ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`03ooooo`;o0000Eoooool3o`0000Oooooo001Oooooo`;o0000
1oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Sooooo0_l00008ooooo`;o0000
1_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo0_l00009ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool01_ooool2o`0005oooooo001Looooo`?o00002_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Gooooo0_l0000<ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`;o00001_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo0ol0001Looooo`00F_ooool2
o`0000kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`;o00003_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Oooool2
o`0005[ooooo001Gooooo`?o00004Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00;o00004Oooool2o`0000;ooooo00Go0000ooooooooooooooooo`00000Aooooo`;o000000?ooooo
o`000?ooool04?ooool00ol0003oooooooooo`0@ooooo`?o0000Eoooool005Gooooo0_l0000Eoooo
o`03o`000?oooooooooo00oooooo0_l0000=ooooo`Go00000oooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo01;ooooo0_l0000@ooooo`03o`000?oooooooooo01Cooooo0_l0001Eoooo
o`00Doooool2o`0001Sooooo00?o0000ooooooooool03?ooool2o`000003ooooool0003o000000go
oooo00Co0000oooooooooooo00001?ooool2o`000003ooooool0003ooooo01?ooooo00?o0000oooo
ooooool00_l0000>ooooo`03o`000?oooooooooo01Kooooo0_l0001Cooooo`00D?ooool3o`0001_o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01Oooool3o`0001?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo01Wooooo0ol0001@ooooo`00C_ooool2o`0001oooooo
00?o0000ooooooooool01oooool2o`0000Oooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`03ooooo`;o000000?oooooo`000?ooool04Oooool00ol0003oooooooooo`05ooooo`;o0000
2Oooool00ol0003oooooooooo`0Mooooo`?o0000COooool004_ooooo0ol0000Rooooo`03o`000?oo
oooooooo00Cooooo0_l0000:ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooooooooooo
o`000003ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`08ooooo`;o00001_ooool00ol0003oooooooooo`0Qooooo`?o0000B_ooool004Sooooo0ol0
000Vooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`06ooooo`06o`000?ooooooooooooooool0003ooooo0_l00002ooooo`05o`000?oooooooooooooo
ool000003_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool09Oooool3o`0004Oooooo0015ooooo`?o0000:_ooool01?l0003oooooo`000?l0000?oooo
o`03o`000?oooooooooo00Kooooo0ol000000ooooooo0000ooooo`03ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0=ooooo`;o000000?oooooo`00
0?ooool0:_ooool3o`0004Cooooo0012ooooo`?o0000;Oooool2o`0001;ooooo00?o0000oooooooo
ool01oooool2o`0000Gooooo00?o0000ooooooooool00oooool2o`0000Wooooo00?o0000oooooooo
ool04?ooool2o`0002kooooo0_l00012ooooo`00?oooool3o`0002kooooo0_l000000ooooooo0000
ooooo`0Booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Oooool01?l0003ooooo
o`000?l0000^ooooo`?o0000?oooool003gooooo0_l0000`ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`02ooooo`;o00002?ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo02kooooo0_l0000mooooo`00>oooool2o`00033ooooo0_l0
0006ooooo`03o`000?oooooooooo017ooooo00Co0000oooooooooooo00002_ooool00ol0003ooooo
ooooo`07ooooo`05o`000?ooooooooooooooool000004oooool00ol0003oooooooooo`04ooooo`;o
0000<?ooool2o`0003_ooooo000hooooo`?o0000<?ooool2o`0000Wooooo00?o0000ooooooooool0
4Oooool2o`0000_ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Cooooo`03o`00
0?oooooooooo00Oooooo0_l0000`ooooo`?o0000>?ooool003Kooooo0_l0000booooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool03oooool01?l0003oooooo`000?l0000:ooooo`;o0000
2_ooool2o`0001;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0`ooooo`;o0000
=_ooool003?ooooo0ol0000booooo`;o00003Oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`04o`000?oo
ooooooooo`00013ooooo00?o0000ooooooooool03?ooool2o`0003;ooooo0ol0000cooooo`00<?oo
ool3o`0003?ooooo0_l0000@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00oooooo0_l0000cooooo`;o0000<Ooo
ool002gooooo0ol0000dooooo`;o00004oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Cooooo0_l0000<ooooo`03o`000?oooooooooo017ooooo0_l0000cooooo`;o0000;oooool0
02[ooooo0ol0000fooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01oooool2o`00
00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
03;ooooo0ol0000/ooooo`009oooool3o`0003Oooooo0_l0000Hooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Ko
oooo0_l0000eooooo`?o0000:Oooool002Gooooo0_l0000hooooo`;o00006_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00_ooooo0_l00005ooooo`03o`000?oooooooooo01Wooooo
0_l0000fooooo`?o00009_ooool002?ooooo0_l0000iooooo`03o`000?oooooooooo01_ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0?ooooo`05o`000?ooooooooooooooool00000
1?ooool00ol0003oooooooooo`0>ooooo`05o`000?ooooooooooooooool000007_ooool00ol0003o
ooooooooo`0fooooo`?o00008oooool0023ooooo0ol0000iooooo`;o00007oooool01?l0003ooooo
ooooool0000Cooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool04?ooool00ol0
003oooooo`00000Pooooo`;o0000>Oooool3o`00023ooooo000Nooooo`;o0000>_ooool2o`0002;o
oooo0_l0000Eooooo`06o`000?oooooo0000o`000?oooooo00005?ooool2o`0002;ooooo0_l0000j
ooooo`;o00007_ooool001_ooooo0ol0000jooooo`;o00008oooool00ol0003oooooo`00000Foooo
o`;o000000?oooooo`000?ooool05?ooool00ol0003oooooo`00000Sooooo`;o0000>_ooool3o`00
01_ooooo000Iooooo`;o0000??ooool00ol0003oooooooooo`0Rooooo`04o`000?ooooooooooo`00
01Oooooo0_l0000Eooooo`05o`000?ooooooooooooooool000009?ooool00ol0003oooooooooo`0j
ooooo`;o00006Oooool001Oooooo0_l0000looooo`;o00008oooool2o`0000Cooooo00?o0000oooo
ooooool04oooool3o`0001Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Roooo
o`;o0000??ooool2o`0001Oooooo000Dooooo`?o0000??ooool2o`0002Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0Aooooo`05o`000?oooooo0000ooooool000004_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo02?ooooo0_l0000looooo`?o00005?ooool001;o
oooo0_l0000nooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`0?ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`07ooooo`;o00009Oooool00ol0003oooooooooo`0looooo`?o00004Oooool000oo
oooo0ol0000nooooo`;o00009?ooool2o`0000_ooooo00?o0000ooooooooool03Oooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo02?ooooo0_l0000oooooo`?o00003_ooool000cooooo0ol0000oooooo`;o
00009Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`0Tooooo`;o0000@?ooool3o`0000_ooooo0009ooooo`?o0000
@?ooool2o`0002Kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool09Oooool2o`00047ooooo0ol00008ooooo`001ooo
ool2o`0004;ooooo00?o0000ooooooooool09?ooool2o`00017ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`04ooooo`;o00001Oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo00Gooooo0019ooooo`;o00009_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool04Oooool2o`0002Oooooo0_l00019ooooo`00Aoooool2o`00
02Oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool09_ooool2o`0004Oooooo0016ooooo`03o`000?oooooooooo02Go
oooo0_l0000Hooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`07ooooo`05o`000?ooooooooooooooool000006?ooool00ol0003oooooooooo`0Woooo
o`03o`000?oooooooooo04Cooooo0014ooooo`;o00009oooool00ol0003oooooooooo`0Iooooo`04
o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Joooo
o`;o0000:?ooool2o`0004Cooooo0012ooooo`;o0000:?ooool00ol0003oooooooooo`0Kooooo`;o
00002oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01_ooooo00?o0000oooooooo
ool09oooool2o`0004;ooooo0010ooooo`;o0000:?ooool2o`0001gooooo00?o0000ooooool00000
2oooool00ol0003oooooooooo`09ooooo`;o00007Oooool00ol0003oooooooooo`0Xooooo`;o0000
@?ooool003oooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Looooo`04o`000?oo
ooooooooo`0000?ooooo0ol00005ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo
00007Oooool2o`0002[ooooo00?o0000ooooooooool0?Oooool003gooooo0_l0000Yooooo`03o`00
0?oooooooooo01cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000Ko
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01co
oooo00?o0000ooooooooool0:?ooool2o`0003gooooo000kooooo`;o0000:Oooool2o`0001kooooo
00?o0000ooooooooool01?ooool5o`0000Gooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0:Oooool2o`0003_ooooo
000jooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool07Oooool00ol0003ooooooooo
o`05ooooo`;o000000?oooooo`000?ooool01Oooool3o`0000Gooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Looooo`;o0000:oooool00ol0003oooooooooo`0hooooo`00>?ooool2
o`0002[ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`07ooooo`?o00001_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07Oooool0
0ol0003oooooooooo`0Yooooo`;o0000>?ooool003Kooooo0_l0000[ooooo`03o`000?oooooooooo
01gooooo00?o0000ooooooooool02Oooool2o`0000Kooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0:_ooool2o`00
03Kooooo000dooooo`;o0000;?ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00_o
oooo0_l00005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0Mooooo`;o0000;?ooool00ol0003oooooooooo`0cooooo`00<oooool00ol0003ooooo
ooooo`0Zooooo`;o00007oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool0:_ooool2o`0003?ooooo000aooooo`;o0000;?ooool00ol0003ooooooooo
o`0Nooooo`03o`000?oooooooooo013ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0[ooooo`03o`00
0?oooooooooo033ooooo000_ooooo`;o0000;Oooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooooooo01;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo01kooooo0_l0000/ooooo`;o0000<?ooool002kooooo00?o0000ooooooooool0;?oo
ool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01Cooooo00Go0000ooooool0003ooooo
o`00000Eooooo`;o00008?ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02gooooo
000/ooooo`;o0000;_ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01Kooooo0ol0
000Hooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0:oooool2o`0002gooooo000Z
ooooo`;o0000;_ooool2o`00023ooooo00?o0000ooooooooool06?ooool2o`0001Wooooo00?o0000
ooooooooool07_ooool2o`0002gooooo00?o0000ooooooooool0:_ooool002Sooooo0_l0000_oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Ioooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool0:oooool2o`0002[ooooo000Wooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0Iooooo`?o
00006oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo02cooooo0_l0000Xooooo`00
9Oooool2o`0002oooooo0_l0000Qooooo`03o`000?oooooooooo01Wooooo00Go0000ooooool0003o
ooooo`00000Kooooo`03o`000?oooooooooo01oooooo0_l0000^ooooo`;o00009_ooool002?ooooo
0_l0000`ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool06Oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`0]ooooo`;o00009?ooool002;ooooo00?o0000ooooooooool0;oooool00ol0003ooooo
ooooo`0Pooooo`03o`000?oooooooooo01Wooooo00Go0000ooooooooooooooooo`000003ooooo`03
o`000?oooooooooo01Wooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0^ooooo`;o
00008_ooool0023ooooo0_l0000`ooooo`;o00008_ooool00ol0003oooooooooo`0Iooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Iooooo`03o`00
0?oooooooooo023ooooo0_l0000`ooooo`;o00008?ooool001kooooo0_l0000aooooo`03o`000?oo
oooooooo027ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Qooooo`03o`000?oo
oooooooo02oooooo0_l0000Nooooo`007?ooool2o`0003;ooooo00?o0000ooooooooool08Oooool0
0ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Iooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0<?ooool2
o`0001cooooo000Kooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool08Oooool00ol0
003oooooooooo`0Iooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Iooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0<Oooool00ol0
003oooooooooo`0Iooooo`00\
\>"],
  ImageRangeCache->{{{0, 302.625}, {186.688, 0}} -> {-3.15584, -5.00005, \
0.0208564, 0.0535656}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that the graph of the envelope (in red) follows the tangent lines \
which are representatives of the one-parameter family. Go back and eliminate \
the last parameter (1/2) in the definition of ",
  StyleBox["samples",
    FontWeight->"Bold"],
  " and re-execute ",
  StyleBox["lines",
    FontWeight->"Bold"],
  " and this ",
  StyleBox["Show.",
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["An equation for the envelope"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"In this case, we can eliminate t from these two equations and find an \
equation for y in terms of x."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Eliminate", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"x", "==", 
              RowBox[{"-", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
            RowBox[{"y", "==", 
              RowBox[{\(f[t]\), "-", 
                RowBox[{"t", " ", 
                  RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}]}]}], 
          "}"}], ",", "t"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-2\)\ y == x\^2\)], "Output"]
}, Closed]],

Cell[TextData["This is the downward-turning parabola we saw above."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{576, 620},
WindowMargins->{{28, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 97, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1876, 57, 1390, 35, 284, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3291, 96, 86, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3402, 102, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[3495, 106, 167, 5, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3687, 115, 108, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3820, 121, 82, 2, 45, "Input"],
Cell[3905, 125, 48, 1, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3990, 131, 118, 2, 42, "Input"],
Cell[4111, 135, 225, 3, 76, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4373, 143, 154, 4, 43, "Input"],
Cell[4530, 149, 54828, 1108, 241, 7443, 517, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[59361, 1259, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[59540, 1268, 103, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[59646, 1272, 456, 12, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[60127, 1288, 75, 2, 45, "Input"],
Cell[60205, 1292, 41, 1, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[60283, 1298, 714, 18, 43, "Input"],
Cell[61000, 1318, 17595, 470, 182, 4075, 297, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[78598, 1790, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[78777, 1799, 107, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[78909, 1805, 78, 2, 27, "Input"],
Cell[78990, 1809, 45194, 1037, 196, 8341, 576, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[124187, 2848, 130, 3, 27, "Output"]
}, Closed]],
Cell[124332, 2854, 454, 14, 68, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[124823, 2873, 112, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[124938, 2877, 177, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[125140, 2885, 639, 17, 27, "Input"],
Cell[125782, 2904, 51, 1, 29, "Output"]
}, Closed]],
Cell[125848, 2908, 126, 2, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

